local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"

local FlipFlop = BlueNode:extend();

function FlipFlop:new(...)
  FlipFlop.super.new(self, ...)
  self.result = false ;
end


-- 如果获取self.result的值 BlueNode:Update会避免执行当前节点
function FlipFlop:_OnUpdate(args)
  self.result = not self.result
  return self.result
end


function FlipFlop:_OnNextBranch()
  if self.result then
    return 1
  else
    return 2
  end
end

function FlipFlop:_OnReset()
  self.result = false 
end

FlipFlop:RegisterOutput(1, Types.BoolType, "IsA", "Output A will be called?");
FlipFlop:RegisterExecInput(1, "exec", "Execute");
FlipFlop:RegisterExecOutput(1, "A", "execute A");
FlipFlop:RegisterExecOutput(2, "B", "execute B");

FlipFlop:SetFunctionName("Flip Flop");

return FlipFlop;

