local Types = require "venuscore.rtti.types"

local BATNode = require "bluecore.base.blue_anytype_node"
local BlueDynamicAnyTypePinsNode = require "bluecore.base.blue_dynamic_anytype_pins_node"
local BD = require "bluecore.bluedefined"
local BU = require "bluecore.blueutility"

local MakeArray = BlueDynamicAnyTypePinsNode:extend();

---- 游戏运行模式
function MakeArray:new(...)
  MakeArray.super.new(self, ...)
end

function MakeArray:_OnUpdate(args)
  local array = args
  return array;
end

---- 编辑器模式

-- 在编辑器交互上创建时候回调 (避免数据和反序列化重叠 e.g table.insert操作)
function MakeArray:_OnCreateWithEditor()
  MakeArray.super._OnCreateWithEditor(self);
end

-- 当删除pin的时候,由于pin脚顺序发生改变,回调给具体节点类进行修改
function MakeArray:_OnOrderChange(pinInfo, oldIdx, newIdx)
  pinInfo.name = "["..(newIdx).."]"
  pinInfo.tips = "["..(newIdx).."]"
  ERROR("pinInfo Update "..tostring(pinInfo.name)..","..tostring(pinInfo.tips))
end

MakeArray._OnAdd = function(thisNode)
  local inputInfo = thisNode.infoTable[BD.PIN_DATA_INPUT][1]
  local pinUid = thisNode.graph:_NextID();
  local nodeUid = thisNode.uid;
  local inputPin
  if inputInfo ~= nil then -- 根据之前引脚信息,新增其他元素信息
    inputPin = thisNode:AppendInput(inputInfo.rtti, nil, nil, BU:GetDefaultByRtti(inputInfo.rtti), pinUid, nodeUid, true, BATNode.DEFAULT_GROUP);
  else
    inputPin = thisNode:AppendInput(Types.AnyType, "[1]", "[1]", Types.AnyType(), pinUid, nodeUid, true, BATNode.DEFAULT_GROUP);
  end
  return inputPin
end

-- 之前已经删除连接信息,索引表在执行完所有删除操作之后才会移除对应pin/node
MakeArray._OnDel = function(thisNode, inputPin)
  thisNode:RemoveInput(inputPin);
  return true
end

MakeArray:RegisterMoreInput("arraymore", BD.OP_ADD, "增加数组元素", MakeArray._OnAdd, BD.OP_DEL, "删除数组元素", MakeArray._OnDel);
MakeArray:RegisterInput (1, Types.AnyType, "[1]", "[1]", Types.AnyType(), true, BATNode.DEFAULT_GROUP);
MakeArray:RegisterOutput(1, Types.AnyArrayType, "result", "输出数组", Types.AnyArrayType(), false , BATNode.DEFAULT_GROUP);
MakeArray:SetFunctionName("MakeArray");

return MakeArray ;

