local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"

local Types = require "venuscore.rtti.types"

local SetPostEffectActive = BlueNode:extend();

---- 游戏运行模式
function SetPostEffectActive:new(...)
  SetPostEffectActive.super.new(self, ...)
end

function SetPostEffectActive:_OnUpdate(args)
  args[1].Active = args[2];
end



---- 编辑器模式



SetPostEffectActive:RegisterInput(1, Types.CameraPostEffectRefType, "postEffect", "后处理", Types.NotNullType());

SetPostEffectActive:RegisterInput(2, Types.BoolType, "active", "设置后处理激活状态", true);

SetPostEffectActive:RegisterExecInput(1, "exec", "执行");

SetPostEffectActive:RegisterExecOutput(1, "exec", "执行");

SetPostEffectActive:SetFunctionName("SetPostEffectActive");


return SetPostEffectActive;

