require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local fxaa = {}
fxaa.renderObject = nil;
fxaa.queue = 311;

fxaa.material = 0;
fxaa.renderObj = 0;
function fxaa:Initialize(host, size)
  self.relative_threshold = mathfunction.vector1(0.125);
  self.absolute_threshold = mathfunction.vector1(0.0312);
  self.FXAA_RELATIVE_LUMA_THRESHOLD = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"FXAA_RELATIVE_LUMA_THRESHOLD");
  self.FXAA_ABSOLUTE_LUMA_THRESHOLD = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"FXAA_ABSOLUTE_LUMA_THRESHOLD");

  local simplePathGamma= "comm:/documents/material/imageblit.material";
  self.simplecopygammaMaterial = host:CreateMaterial(simplePathGamma);
  self.simplecopygammaRenderObj = host:CreateRenderObject();

  self.material = host:CreateMaterial("comm:documents/material/fxaa_quality.material");
  self.renderObj = host:CreateRenderObject();

  self.material:SetParameter(self.FXAA_RELATIVE_LUMA_THRESHOLD, self.relative_threshold);
  self.material:SetParameter(self.FXAA_ABSOLUTE_LUMA_THRESHOLD, self.absolute_threshold);


  --已经创建好的color attachment无法直接修改采样模式？只能再走一遍渲染pass
  self.linearCopy = host:CreateRenderTarget( apolloengine.RenderTargetEntity.ST_SWAP_A,
      apolloengine.TextureRenderMetadata(
          apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
          size,
          apolloengine.TextureEntity.PF_RG11B10FLOAT
      )
  );

  --host:RegisterScriptParameter(self,"relative_threshold");
  --host:RegisterScriptParameter(self,"absolute_threshold");
  
  return self.queue;

end



function fxaa:Resizeview(size)

end




function fxaa:Process(context, Original, Scene, Output)

  context:BeginRenderPass(self.linearCopy, apolloengine.RenderTargetEntity.CF_COLOR);
  self.simplecopygammaMaterial:SetParameter(
      apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
      Original:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0));
  context:Draw(self.simplecopygammaRenderObj, self.simplecopygammaMaterial);
  context:EndRenderPass();

  context:BeginRenderPass(Output,apolloengine.RenderTargetEntity.CF_COLOR);
  self.material:SetParameter(self.FXAA_RELATIVE_LUMA_THRESHOLD, self.relative_threshold);
  self.material:SetParameter(self.FXAA_ABSOLUTE_LUMA_THRESHOLD, self.absolute_threshold);
  self.material:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.linearCopy:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 )
  );
  context:Draw(self.renderObj,self.material);
  context:EndRenderPass();
end

return fxaa;
