local apollocore = require "apollocore"
local EventDispatcher = require "bluecore.eventdispatcher"
local BlueDefined = require "bluecore.bluedefined"

local stringPlay = "Play"

local gLastEvent = {}
local _fNativeDestroy = apollocore.IComponent.Destroy;
rawset(apollocore.FrameAnimationComponent, "Destroy", function(self)
  local staticID =  self:GetContentPath();
  --for id, _ in pairs(gLastEvent) do
  --  ERROR("FrameAnimation LastEvent staticID: "..tostring(id))
  --end
  gLastEvent[staticID] = nil
  _fNativeDestroy(self);
end);

rawset(apollocore.FrameAnimationComponent, "ResetCached", function(self)
  local staticID =  self:GetContentPath();
  gLastEvent[staticID] = nil
end);

rawset(apollocore.FrameAnimationComponent, "CutterActvieContent",
  function(self)
    self:Reset();
  end);


rawset(apollocore.FrameAnimationComponent, "GetProperties",
  function(self, type_name)
    local res = apollocore.IContent.GetProperties(self, type_name); --先取得其余的属性
    local entitys = self.aniEntityArray;
    for index, entity in ipairs(entitys) do
      local propString = string.format(
        "aniEntityArray%s%d%s%s", 
        self.SEP, 
        index, 
        self.SEP, 
        stringPlay
      );
      table.insert(res, propString);
    end
    return res;
  end);


rawset(
  apollocore.FrameAnimationComponent,
  "GetScriptPropValue",
  function(self, prop)
    if string.find(prop, stringPlay) then
      local keys = string.split(prop, self.SEP);
      local index = tonumber(keys[2]);
      local entity = self.aniEntityArray[index];
      local status = entity:GetAnimationStatus();
      return status == apollocore.IComponent.AS_PLAYING;
    end
    return apollocore.IContent.GetScriptPropValue(self, prop);
  end
);

rawset(
  apollocore.FrameAnimationComponent,
  "SetScriptPropValue",
  function(self, prop, value)
    if string.find(prop, stringPlay) then
      local keys = string.split(prop, self.SEP);
      local index = tonumber(keys[2]);
      if value then
        self:Play(index - 1); --现在统一从component调用play感觉有点难受
      else
        self:Stop(index - 1);
        self:Reset(index - 1);
      end
    else
      apollocore.IContent.SetScriptPropValue(self, prop, value);
    end
  end
);

--FXIME(hjh)这几行是不是可以去掉了...
--EventDispatcher:RegisterEvent(apollocore.FrameAnimationComponent:GetTypeName(), BlueDefined.Event.FrameAnimationEvent.Play);
--EventDispatcher:RegisterEvent(apollocore.FrameAnimationComponent:GetTypeName(), BlueDefined.Event.FrameAnimationEvent.Stop);
--EventDispatcher:RegisterEvent(apollocore.FrameAnimationComponent:GetTypeName(), BlueDefined.Event.FrameAnimationEvent.End);
--EventDispatcher:RegisterEvent(apollocore.FrameAnimationComponent:GetTypeName(), BlueDefined.Event.FrameAnimationEvent.LoopEnd);

local function Listening(status, staticID, eventType)
  if EventDispatcher:HasEventListener(staticID, eventType) then
    if status then --有状态
      if gLastEvent[staticID] and gLastEvent[staticID][eventType] then
        local event = {
        staticID = staticID,
        eventType = eventType,
        params = {
          isEdge = false
        }
        };
        EventDispatcher:PushEvent(event);
      else
        gLastEvent[staticID] = gLastEvent[staticID] or {};
        gLastEvent[staticID][eventType] = true;
        local event = {
        staticID = staticID,
        eventType = eventType,
        params = {
          isEdge = true --边缘触发
        }
        };
        EventDispatcher:PushEvent(event);
      end  
    else --没状态不触发并且清空掉东西
      gLastEvent[staticID] = gLastEvent[staticID] or {};
      gLastEvent[staticID][eventType] = false;
    end  
  end
end



local _nativeUpdate = apollocore.FrameAnimationComponent.Update

rawset(
  apollocore.FrameAnimationComponent,
  "Update",
  function(self, delta)
    if not self:isActiveHierarchy() then
      return
    end
    local entities = self.aniEntityArray
    for i = 1, #entities do
      local entity = entities[i]
      local status = entity:GetAnimationStatus()
      local isPlaying  = status == apollocore.IComponent.AS_PLAYING
      local hasDone    = status == apollocore.IComponent.AS_DONE
      local hasStopped = status == apollocore.IComponent.AS_STOP
      local staticID = self:GetContentPath();
      if EventDispatcher:HasCompListener(staticID) then--不是蓝图里面注册的监听就不要触发
          Listening(isPlaying, staticID, BlueDefined.Event.FrameAnimationEvent.Play);
          Listening(hasDone, staticID, BlueDefined.Event.FrameAnimationEvent.End);
          Listening(hasStopped, staticID, BlueDefined.Event.FrameAnimationEvent.Stop);
      end
      --Listening(hasLoopDone, self, BlueDefined.Event.FrameAnimationEvent.LoopEnd);
      --local hasLoopDone = status == apollocore.IComponent.AS_LOOP_CONTINUE
      --FIXME(hjh) 如果是循环播放 播放终止则不会判断为AS_DONE状态  但是也没有判断为AS_LOOP_CONTINUE状态
      if entity.autoShowHideRenders then
        local renderCount = entity:GetBindRenderComponentNum()
        for j = 1, renderCount do
          local render = entity:GetBindRenderComponent(j - 1)
          if render then
            if isPlaying then
              if not render.Active then
                render.Active = true
              end
            elseif hasDone or hasStopped then
              if render.Active then
                render.Active = false
              end
            end
          end
        end
      end
    end
    _nativeUpdate(self, delta)
  end
);
