#pragma once

#include "commonvar.inc"

struct GBufferData
{
	float3 base_color;
	float alpha;	
	float3 world_normal;	
	float smoothness;	
	float3 basepass_color;	
	float metalness;
};

//Used in Cry Engine 3, presented by Martin Mittring in "A bit more Deferred" presentation 

float2 EncodeNormal( float3 N )
{
	float f = N.z*2+1;
	float g = dot(N,N);
	float p = sqrt(g+f);
	return N.xy/p * 0.5 + 0.5;
}

float3 DecodeNormal( float2 enc )
{
	float3 n;
	n.xy = -enc*enc+enc;
	n.z = -1;
	float f = dot(n, float3(1,1,0.25));
	float m = sqrt(f);
	n.xy = (enc*8-4) * m;
	n.z += 8*f;
	return n;
}


void EncodeGBuffer(in GBufferData data, inout float4 result[3])
{
  // 压缩法线可能导致精度丢失，计算出空值(Nan)
	//float2 normalWorld = EncodeNormal(data.world_normal);
	//result[0] = float4(normalWorld,data.alpha, data.metalness);
	float3 data_wn = (data.world_normal + float3(1.0, 1.0, 1.0)) / 2.0;
	result[0] = float4(data.basepass_color, 1.0);
	result[1] = float4(data.base_color, data.smoothness);
	result[2] = float4(data_wn, data.metalness);
}

GBufferData DataToGBuffer(float4 data0, float4 data1, float4 data2)
{
	GBufferData data;

	data.base_color = data1.xyz;
	//data.alpha = data0.z;
	data.alpha = 1.0;
	//data.world_normal = DecodeNormal(data0.xy);
	data.world_normal = data2.xyz;
	data.world_normal = (data.world_normal * 2.0) - float3(1.0, 1.0, 1.0);
	data.smoothness = data1.w;
	data.basepass_color = data0.xyz;
	data.metalness = data2.w;

	return data;
}

GBufferData DecodeGBuffer(float2 texcoord, Texture2D GBufferA, 
Texture2D GBufferB, Texture2D GBufferC, SamplerState SamplerA,
SamplerState SamplerB,SamplerState SamplerC)
{
	float4 data0 = GBufferA.Sample(SamplerA, texcoord);
	float4 data1 = GBufferB.Sample(SamplerB, texcoord);
	float4 data2 = GBufferC.Sample(SamplerC, texcoord);

	return DataToGBuffer(data0, data1, data2);
}

float3 WorldPosFromDepth(float NDCDepth, float2 uv)
{
    float x = uv.x;
    float y = uv.y;
    x = x * 2 -1;
    y = (1 - y) * 2 -1;
    float4 projectedPos = float4(x, y, NDCDepth, 1.0f);
    float4 worldPosClip = mul(projectedPos, CAMERA_VIEWPROJ_INV);
	return worldPosClip.xyz / worldPosClip.w;
}

float3 ViewPosFromDepth(float NDCDepth, float2 uv)
{
  float3 worldPos = WorldPosFromDepth(2.0 * NDCDepth - 1.0, uv);
  float4 viewPos = mul(float4(worldPos, 1.0), CAMERA_VIEW);
	return viewPos.xyz / viewPos.w;
}


// @param DeviceZ value that is stored in the depth buffer (Z/W)
// @return SceneDepth (from [0,1] to [-1, 1], nonlinear depth)
float ConvertFromDeviceZ(float DeviceZ)
{
  return (2.0 * DeviceZ - 1.0);
}