#pragma once
//Brown–Conrady model
// positive values of K1 give barrel distortion, negative give pincushion
//@uv_in : coordinate relative to distortion center
inline float2 brownConradyDistortion(float2 uv_in, float k1, float k2)
{    
	float2 uv = uv_in;

    float r2 = uv.x*uv.x + uv.y*uv.y;
    uv *= 1.0 + k1 * r2 + k2 * r2 * r2;

    return uv;
}

//fisheye model
//@half_theta : (0, 90] in degree 
inline float2 fishEye(in float2 uv_in, in float2 center, in float2 radius, in float half_theta)
{
	float2 uv = (uv_in - center) / radius;
	const float pi_1_2 = 1.57079632679 / 90.0;
	float alpha = half_theta * pi_1_2 ;
	float n = sqrt(dot(uv,uv));
	float r = asin(n*sin(alpha))/alpha;
	uv = r * uv * radius / n + center;
	return uv;
}


