#include"functions/rgb_hsv.function"

#SHADER_DEFINE SkinDetectVertex

    FUNCTION_INPUT = 
    {
        { ATTRIBUTE_POSITION,        HIGH,    VEC4,        "in_Position" },
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "in_TexCoordinate" },
    }
    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "out_TexCoordinate" },
    }

#SHADER_CODE

    gl_Position = in_Position;
    vec2 out_TexCoordinate = in_TexCoordinate.xy;

#END_CODE
#END_DEFINE


#SHADER_DEFINE  SkinDetectFragment

    FUNCTION_INPUT = 
    {
        { TEXTURE_DIFFUSE,           NONE,      TEXTURE2D,   "in_DiffuseTexture" },
        { ATTRIBUTE_COORDNATE0,      HIGH,      VEC2,        "in_TexCoordinate" },
    }

#SHADER_CODE
    vec4 Color = texture2D(in_DiffuseTexture, in_TexCoordinate);
    if(Color.r>0.3725&&Color.g>0.156&&Color.b>0.0039){
      if(Color.r>Color.g&&Color.r>Color.b&&(Color.r-Color.b)>0.058&&(Color.r-min(Color.b,Color.g))>0.058){
        gl_FragColor = vec4(1.0,1.0,1.0,1.0);
      }
      else{
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
      }
    }
    else{
      gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    }
    /*vec3 hsv = rgb2hsv(Color.rgb);
    if(hsv.x>=0.0&&hsv.x<=50.0&&hsv.y>0.23&&hsv.y<0.68&&Color.r>0.3725&&Color.g>0.156&&Color.b>0.0039){
      if(Color.r>Color.g&&Color.r>Color.b&&(Color.r-Color.b)>0.058&&(Color.r-min(Color.b,Color.g))>0.058){
        gl_FragColor = vec4(1.0,1.0,1.0,1.0);
      }
      else{
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
      }
    }
     else{
      gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    }*/
#END_CODE
#END_DEFINE







