#SHADER_DEFINE SkinbrightblendVertex

    FUNCTION_INPUT =
    {
        { ATTRIBUTE_POSITION,        HIGH,    VEC4,        "in_Position" },
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "in_TexCoordinate" },
    }
    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,      HIGH,    VEC2,        "out_TexCoordinate" },
    }

#SHADER_CODE

    gl_Position = in_Position;
    vec2 out_TexCoordinate = in_TexCoordinate.xy;

#END_CODE
#END_DEFINE


#SHADER_DEFINE  SkinbrightblendFragment

    FUNCTION_INPUT =
    {
        { TEXTURE_DIFFUSE,           NONE,      TEXTURE2D,      "in_DiffuseTexture" },
        { TEXTURE_BRIGHTLUT,         NONE,      TEXTURE2D,     "in_BrightLutTexture"},
        { UNIFORM_INTENSITY,         MEDIUM,    FLOAT,                   "intensity"},
        { ATTRIBUTE_COORDNATE0,      HIGH,      VEC2,            "in_TexCoordinate" },
    }

#SHADER_CODE
    lowp vec4 originColor = texture2D(in_DiffuseTexture, in_TexCoordinate);
    lowp vec4 brightColor = texture2D(in_BrightLutTexture, in_TexCoordinate);
    gl_FragColor = mix(originColor,brightColor,intensity);
#END_CODE
#END_DEFINE
