#include "functions/lut.function"
#SHADER_DEFINE LutVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
   
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_TexCooridate = in_TexCooridate.xy;
#END_CODE
#END_DEFINE

#SHADER_DEFINE LutFragment

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"uniCurrentTexture" },
    { LOOKUPTABLE,		NONE,	TEXTURE2D,		"lookUpTable" },
		{ ATTRIBUTE_COORDNATE0,		HIGH,	VEC2,		"textureCoordinate"},
	}
  
#SHADER_CODE
   vec3 rgb3 = texture2D(uniCurrentTexture,textureCoordinate).rgb;
   vec4 rgb4 = vec4(rgb3,1.0);
   gl_FragColor = LUT(rgb4,lookUpTable);
#END_CODE
#END_DEFINE

#SHADER_DEFINE LutFragment_Hald

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"uniCurrentTexture" },
    { LOOKUPTABLE,		NONE,	TEXTURE2D,		"lookUpTable" },
		{ ATTRIBUTE_COORDNATE0,		HIGH,	VEC2,		"textureCoordinate"},
	}
  
#SHADER_CODE
   vec3 rgb3 = texture2D(uniCurrentTexture,textureCoordinate).rgb;
   vec4 rgb4 = vec4(rgb3,1.0);
   gl_FragColor = LUT_Hald(rgb4,lookUpTable);
#END_CODE
#END_DEFINE
   
   