
#DEFPARAMS

#END
 
   
#DEFTAG
ShaderName = "boxblur"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

Texture2D TEXTURE_REFLECT;
SamplerState TEXTURE_REFLECT_SAMPLER;
float2 texSize;

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
	float2 coord = i.uv;
	//outColor = TEXTURE_REFLECT.Sample(TEXTURE_REFLECT_SAMPLER, coord);
	outColor.rgba = float4(0.0,0.0,0.0,0.0);
	int size = 1;
	//int count = 0;
	//if(outColor.a > 0)
	{
		for (int i = -size; i <= size; ++i) 
		{
			for (int j = -size; j <= size; ++j) 
			{
				outColor.rgba += TEXTURE_REFLECT.Sample(TEXTURE_REFLECT_SAMPLER, coord + float2(i,j)/texSize).rgba;
				//count += 1.0;
			}
		}
		outColor.rgba /= 9;
	}

}

ENDCG
#END

