

#DEFPARAMS
#END

#DEFTAG
ShaderName = "BrightnessMap"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
#include "rgb_hsv.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float3 rgbcolor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv).rgb;
    float3 hsvcolor = rgb2hsv(rgbcolor);
    mainColor = float4(float3(hsvcolor.z,hsvcolor.z,hsvcolor.z), 1.0);
}
ENDCG
#END
