CGPROGRAM
#pragma compute CSMain
#define NUM_THREADS 8
#include "fluid_simulation.inc"

float3 _rigidPos;

float3x3 _rigidRotation;
float3x3 _rigidRotationInv;

float3 _rigidScale;

float3 _rigidLinearVel;
float3 _rigidAngularVel;

float3 _rigidHalfExtent;
float _rigidType;

float _isFirst;


RWStructuredBuffer<float4> _Write4f;
RWStructuredBuffer<float4> _Write3f;

[numthreads(NUM_THREADS,NUM_THREADS,NUM_THREADS)]
void CSMain (int3 id : SV_DispatchThreadID)
{
	int idx = dot(id, float3(1, _Size.xw));
	// if(_Write4f[idx].x > 0)
		// return;
		
	float3 wpos = GridCord2WorldPos(float3(id));
	float d;
	
	float3 tpos = mul(_rigidRotation, wpos - _rigidPos);
	float3 normal;
	if(_rigidType == 0.0) //Box
	{
		d = sdBox(tpos, _rigidScale * _rigidHalfExtent * 2.0);
		normal = mul(_rigidRotationInv, calcBoxNormal(tpos, _rigidScale * _rigidHalfExtent * 2.0));
	}
	else if(_rigidType == 1.0) //CYLINDER
	{
		d = sdCappedCylinder(tpos, _rigidHalfExtent.y, _rigidHalfExtent.x);
		normal = mul(_rigidRotationInv, calcCylinderNormal(tpos, _rigidHalfExtent.y, _rigidHalfExtent.x));
	}
	else if(_rigidType == 2.0) //CAPSULE
	{
		d = sdVerticalCapsule(tpos, _rigidHalfExtent.y, _rigidHalfExtent.x);
		normal = mul(_rigidRotationInv, calcCapsuleNormal(tpos, _rigidHalfExtent.y, _rigidHalfExtent.x));
	}
	else if(_rigidType == 3.0) //Sphere
	{
		d = sdSphere(wpos-_rigidPos, _rigidHalfExtent.x );
		normal = calcSphereNormal(tpos, _rigidHalfExtent.x);
	}
	else if(_rigidType == 4.0) //Cone
	{
		float bedge = sqrt(_rigidHalfExtent.x*_rigidHalfExtent.x + _rigidHalfExtent.y * _rigidHalfExtent.y);
		float2 cc = float2(_rigidHalfExtent.x / bedge, _rigidHalfExtent.y / bedge);
		d = sdConeHP(tpos, cc, _rigidHalfExtent.y);
		normal = mul(_rigidRotationInv, calcConeNormal(tpos, cc, _rigidHalfExtent.y));
	}
	
	float3 vel = _rigidLinearVel + cross(_rigidAngularVel, (wpos-_rigidPos));
	
	_Write4f[idx] = float4(-d, vel);
	_Write3f[idx] = float4(normal, 0.0);
		


	
}

ENDCG

