#DEFPARAMS
TEXTURE_DIFFUSE = { "tex diffuse", TEXTURE2D, "white" },
ENABLE_TEXTURE = { "enable texture", FLOAT, "0.0"},
SIM_SPACE = {"sim space", FLOAT, "0.0"},
TEXTUREMODE = {"texture mode", FLOAT, "2.0"},
SIZE_SCALE = {"size scale", FLOAT, "1.0"},
_Opacity = { "Opacity", FLOATRANGE, "1.0, 1, 0" },
[Keywords(BLEND_NORMAL, BLEND_MULTIPLY, BLEND_SCREEN, BLEND_HUE, BLEND_SATURATION, BLEND_LUMINOSITY, BLEND_COLOR, BLEND_BLEND, BLEND_EXCLUSION, BLEND_HARDLIGHT, BLEND_VIVIDLIGHT, BLEND_OVERLAY, BLEND_COLORBURN, BLEND_COLORDODGE, BLEND_SOFTLIGHT, BLEND_HARDMIX, BLEND_PINLIGHT, BLEND_LINEARLIGHT, BLEND_DIFF, BLEND_LINEARBURN, BLEND_SUB, BLEND_LUT, BLEND_ADD)]
_BlendMode = {"Blend Mode", FLOAT, "0.0"},
[Enum(BlendFactor)]
_BlendSrc = {"Blend Src", FLOAT, "4.0"},
[Enum(BlendFactor)]
_BlendDst = {"Blend Dst", FLOAT, "5.0"},
_DefMode = { "Def Mode", FLOAT, "0.0"},
_LutMap = {"Lut Map", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "particle_trail"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, "%_BlendSrc",  "%_BlendDst" , ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fbfetch
#include "common.inc"
#include "blendfunc_plenty.inc"
#pragma multi_compile BLEND_NORMAL BLEND_MULTIPLY BLEND_SCREEN BLEND_HUE BLEND_SATURATION BLEND_LUMINOSITY BLEND_COLOR BLEND_BLEND BLEND_EXCLUSION BLEND_HARDLIGHT BLEND_VIVIDLIGHT BLEND_OVERLAY BLEND_COLORBURN BLEND_COLORDODGE BLEND_SOFTLIGHT BLEND_HARDMIX BLEND_PINLIGHT BLEND_LINEARLIGHT BLEND_DIFF BLEND_LINEARBURN BLEND_SUB BLEND_LUT BLEND_ADD

struct appdata
{
  float4 in_Color : COLOR0; // particle'color
  float4 in_Paras : TEXCOORD3; // segorder, seg num, uvx, color.alpha
  float3 in_Right : TEXCOORD1; // chainTangent
  float3 in_Pos : TEXCOORD2;  //oriPosIndex
};

struct v2f
{
  float4 vertex : SV_POSITION;
  float2 uv : TEXCOORD0;
  float4 out_SurfaceColor: TEXCOORD3;
  float4 screenPos : TEXCOORD4;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
float     ENABLE_TEXTURE;
float     SIM_SPACE;
float4    COLOR_ARRAY[20]; // trail'color
float     TEXTUREMODE;
float     SIZE_SCALE;
float     _DefMode;

v2f vert(appdata v)
{
  float4x4 in_LocalWorld = LOCALWORLD_TRANSFORM;
  float4x4 in_ViewProj = CAMERA_VIEWPROJ;
  float3   in_ViewOrigin = CAMERA_WORLDPOSITION;
  float    in_SimSpace = SIM_SPACE;
  float    init_width = v.in_Paras.z > 0.0 ? v.in_Paras.z : -v.in_Paras.z;
  float    texture_mode = TEXTUREMODE;
  float    segOrder = v.in_Paras.x;
  float    segNum = v.in_Paras.y;
  float    uvy = v.in_Paras.z > 0.0 ? 1.0 : 0.0;
  float    size_scale = SIZE_SCALE;
  
  v2f o;
  o.vertex = float4(0.0f, uvy - 0.5f, 0.0f, 1.0f);
  int idx = int(segOrder / segNum * 19);

  float4 blendColor = COLOR_ARRAY[idx];

  float wid_ = init_width * size_scale;

  float2 uv;
  if(texture_mode == 2.0f)
  {
    uv = float2(segOrder / segNum, uvy);
  }
  else if(texture_mode == 3.0f)
  {
    uv = float2(segOrder, uvy);
  }
  else
  {
    uv = float2(segOrder * init_width, uvy);
  }
  v.in_Color.a = v.in_Paras.w > 0.0f ? v.in_Color.a: 0.0f;
  o.out_SurfaceColor = v.in_Color * blendColor;
  o.uv = uv;

  float flag = step(1.5, in_SimSpace);
  float4 worldPosition = float4(v.in_Pos,1.0) * flag + (1.0 - flag) * mul(float4(v.in_Pos,1.0), in_LocalWorld);
  float3 axisRight = normalize(v.in_Right);

  float3 diff = in_ViewOrigin - worldPosition.xyz;
  float3 axisUp =  normalize(cross(diff, axisRight));

 
  worldPosition.xyz += axisUp * o.vertex.y  * wid_;
  o.vertex = mul(worldPosition, in_ViewProj);
  o.screenPos = ComputeScreenPos(o.vertex);
  o.vertex = UniformNDC(o.vertex);
  return o;
}

float4 GetSourceColor(v2f i, float4 fbColor)
{
#if FRAMEBUFFER_FETCH 
	return fbColor; 
#else
	float2 uvCoord = i.screenPos.xy / i.screenPos.w;
	float4 srcColor = TEXTURE_GRAP.Sample(TEXTURE_GRAP_Sampler, uvCoord);
	return srcColor;
#endif
}

Texture2D _LutMap;
SamplerState _LutSampler;
float _Opacity;

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
#define in_Texture TEXTURE_DIFFUSE
#define in_EnableTexture ENABLE_TEXTURE
  float flag = step(0.5,in_EnableTexture);
  float4 in_SurfaceColor = float4(TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, fmod(i.uv,1.0)));
  float4 blendColor = i.out_SurfaceColor*(in_SurfaceColor * flag + (1.0 - flag));
  float4 resultColor = float4(1.0, 1.0, 1.0, 1.0);
  float  factor = _Opacity * blendColor.a;

#if FRAMEBUFFER_FETCH 
	#if SHADER_API_GLES || SHADER_API_GLES3
	float4 fbc = FramebufferFetchES2();
	#else
	float4 fbc = float4(0.0, 0.0, 0.0, 0.0);
	#endif
#else
	float4 fbc = resultColor;
#endif

#if BLEND_NORMAL
    resultColor = float4(blendColor.r, blendColor.g, blendColor.b, factor);
#elif BLEND_MULTIPLY
    float4 whiteColor = float4(1.0, 1.0, 1.0, 1.0);
    blendColor = whiteColor - factor * (whiteColor - blendColor);
    resultColor = float4(blendColor.r, blendColor.g, blendColor.b, 1.0);
#elif BLEND_SCREEN
    blendColor = factor * blendColor;
    resultColor = float4(blendColor.r, blendColor.g, blendColor.b, 1.0);
#elif BLEND_HUE
    float4 srcColor = GetSourceColor(i, fbc);
    float3 baseHSL = RGBToHSL(srcColor.rgb);
    float3 blendHSL = RGBToHSL(blendColor.rgb);
    float3 resHSLColor = HSLToRGB(float3(blendHSL.r, baseHSL.g, baseHSL.b));
    resultColor.rgb = resHSLColor;
    resultColor.a = factor;
#elif BLEND_SATURATION
    float4 srcColor = GetSourceColor(i, fbc);
    float3 baseHSL = RGBToHSL(srcColor.rgb);
    float3 blendHSL = RGBToHSL(blendColor.rgb);
    float3 resHSLColor = HSLToRGB(float3(baseHSL.r, blendHSL.g, baseHSL.b));
    resultColor.rgb = resHSLColor;
    resultColor.a = factor;
#elif BLEND_LUMINOSITY
    float4 srcColor = GetSourceColor(i, fbc);
    float3 baseHSL = RGBToHSL(srcColor.rgb);
    float3 blendHSL = RGBToHSL(blendColor.rgb);
    float3 resHSLColor = HSLToRGB(float3(baseHSL.r, baseHSL.g, blendHSL.b));
    resultColor.rgb = resHSLColor;
    resultColor.a = factor;
#elif BLEND_COLOR
    float4 srcColor = GetSourceColor(i, fbc);
    float3 baseHSL = RGBToHSL(srcColor.rgb);
    float3 blendHSL = RGBToHSL(blendColor.rgb);
    float3 resHSLColor = HSLToRGB(float3(blendHSL.r, blendHSL.g, baseHSL.b));
    resultColor.rgb = resHSLColor;
    resultColor.a = factor;
#elif BLEND_BLEND
    float4 srcColor = GetSourceColor(i, fbc);
    float imgIntensity = dot(float3(0.2990,0.5870,0.1140), srcColor.rgb);
    float3 resIntColor = (imgIntensity * 1.68) * blendColor.rgb;
    resultColor.rgb = resIntColor;
    resultColor.a = factor;
#elif BLEND_EXCLUSION
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendExclusion(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
#elif BLEND_HARDLIGHT
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendHardLight(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
#elif BLEND_VIVIDLIGHT
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendVividLight(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
#elif BLEND_OVERLAY
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendOverlay(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
#elif BLEND_COLORBURN
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendColorBurn(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
#elif BLEND_COLORDODGE
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendColorDodge(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
#elif BLEND_SOFTLIGHT
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendSoftLight(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
#elif BLEND_HARDMIX
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendHardMix(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
#elif BLEND_PINLIGHT
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendPinLight(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
#elif BLEND_LINEARLIGHT
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendLinearLight(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
#elif BLEND_DIFF
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendDiff(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
#elif BLEND_LINEARBURN
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendLinearBurn(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
#elif BLEND_SUB
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.rgb = BlendSub(srcColor.rgb, blendColor.rgb);
    resultColor.a = factor;
#elif BLEND_LUT
    float4 srcColor = GetSourceColor(i, fbc);
    resultColor.r = _LutMap.Sample(_LutSampler, float2(blendColor.r, srcColor.r)).r;
    resultColor.g = _LutMap.Sample(_LutSampler, float2(blendColor.g, srcColor.g)).g;
    resultColor.b = _LutMap.Sample(_LutSampler, float2(blendColor.b, srcColor.b)).b;
    resultColor.a = factor;
#elif BLEND_ADD
    blendColor = blendColor * factor;
    resultColor = float4(blendColor.r, blendColor.g, blendColor.b, factor);
#endif

    mainColor = resultColor;
}
ENDCG
#END
