local venuscore = require "venuscore"
local soundeffect = require "facecute.soundeffect.soundeffect"
local soundeffect3 = soundeffect:extend();


function soundeffect3:new()
  soundeffect3.super.new(self);
  self.cur_state3 = "invisible";
  self.triggerFlag = false
  self.name = nil
end

function soundeffect3:Play(delay, loop, lastingFrame, fadingFrame, donecallback)
  self.delay = tonumber(delay);
  self.loop = tonumber(loop);
  self.soundplayer:PlaySound(self.loop);
  self:setState("playing")
end

function soundeffect3:Stop()
  self:StopSound();
  self:setState("invisible")
end

--FIXME
function soundeffect3:Pause()
  self:setState("paused")
end

--FIXME
function soundeffect3:PauseInFirstFrame()
  self:setState("first_frame")
end

--FIXME
function soundeffect3:PauseInLastFrame()
  self:setState("last_frame")
end

function soundeffect3:Hide()
  self:setState("invisible")
  self:Stop();
end

function soundeffect3:TestTrigger()
  if self.triggerFlag then
    self.triggerFlag = false
    return self.cur_state3
  end
  return nil
end

function soundeffect3:setState(state)
  if self.cur_state3 ~= state then
    self.triggerFlag = true
    self.cur_state3 = state
  end
end

--传入数据表，解析数据
function soundeffect3:ParseConfig(m, param)
  self.path = param[1].."/"..m.name;
  self.path = venuscore.IFileSystem:PathAssembly(self.path);

  local res = self.soundplayer:LoadSound(self.path);
  return res;
end

function soundeffect3:getAsset(name)
  if (name == self.name) then
    return self
  end
  return nil;
end

function soundeffect3:Update(timespan,face,position, rotation,action)

end

return soundeffect3;