
local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local defined = require "apolloutility.defiend"
local mathfunction = require "mathfunction"
local apolloengine = require "apollocore"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local apollocore = require "apollocore"
local apolloDefine = require "apolloutility.defiend"
local Sticker = require "editorscene.stickerscene"
local colorspaceconverter = require "colorspaceconverter"

--renderqueue中的layer名称和对应scene的渲染顺序
local LAYER_FACE_BEAUTY = "FaceBeautify"
local LAYER_EDITOR_MAKE_UP   = "EditorMakeUp"
local LAYER_STYLISH = "Stylish"
local LAYER_STICKER = "Sticker"

local LAYER_FACEBUAUTY_SEQUENCE = -300
local LAYER_MAKEUP_SEQUENCE = -200
local LAYER_STYLISH_SEQUENCE = -100
local LAYER_STICKER_SEQUENCE = 100  --scene的渲染

--编辑器素材统一加载接口
local SceneLoader = {}

--param: preLayer      贴纸上一层的标记
function SceneLoader:Initialize()
  self.sceneList = {};
  self.InputTex = nil;

  self.converter = colorspaceconverter.new();
  local viewSize = apolloengine.Framework:GetResolution();
  -- create converter from default scene
  local isSRGB2Linear = true;
  local LayerMask = "sceneLoaderGTL";
  self.converter:Initialize_sRGB_Transfer(nil, isSRGB2Linear, mathfunction.vector2(viewSize:x(), viewSize:y()), LayerMask);
  self.converter:Deactivate();
end

function SceneLoader:Update(spantime)
  self:UpdateFacebeauty(spantime);
  self:UpdateMakeup(spantime);
  self:UpdateStylish(spantime);
  self:UpdateSticker(spantime);
end

function SceneLoader:OnRecordStart()
end

--一次卸载所有素材
function SceneLoader:ReleaseAllResource()
  self:ReleaseSticker();
  self.converter:Delete_sRGB_Transfer();
end


-------------------------------------------------------贴纸-----------------------------------------------------------------
--当贴纸加载
function SceneLoader:LoadAsSticker(path)
  --只能加载一个贴纸
  if self.sceneList[LAYER_STICKER] then
    self.sceneList[LAYER_STICKER]:ReleaseSticker();
  end
  
  local rootConfig = venusjson.LaodJsonFile(path);
  if rootConfig.scene then
    renderqueue:Activate(LAYER_STICKER);

    -- set global color space settings before loading resources.
    local AdvancedShadingSetting = false;
    if rootConfig.AdvancedShading == true then
          AdvancedShadingSetting = true;
    end
    apollocore.Framework:SetCurrentAdvancedShading(AdvancedShadingSetting);

    self.InputTex = renderqueue:GetTexture(LAYER_STICKER);
    self.converter:SetCamTexEntity(self.InputTex);
    apollocore.IResourceSystem:ResourcekeyRedirect(
      defined.LAST_QUEUE_TEXTURE, 
      defined.LAST_QUEUE_TEXTURE_STICKER);

    if AdvancedShadingSetting == true then
      self.converter:Activate();
      apolloengine.DeviceResource:PushDeviceResource(
        defined.LAST_QUEUE_TEXTURE_STICKER,
        self.converter.sRGB_Transfer.texture);
    else
      self.converter:Deactivate();
      apolloengine.DeviceResource:PushDeviceResource(
        defined.LAST_QUEUE_TEXTURE_STICKER,
        self.InputTex);
    end
    
    --设置ress路径
    local pathDir= string.match(path, "(.+)/[^/]*%.%w+$");
    local rootdir = pathDir.."/";
    venuscore.IFileSystem:SetResourcePath(rootdir);

    

    local Sticker = Sticker(LAYER_STICKER_SEQUENCE,LAYER_STICKER);
    Sticker.AdvancedShading = AdvancedShadingSetting; 
    Sticker:LoadConfig(rootConfig.scene);
    self.sceneList[LAYER_STICKER] = Sticker;

    

    -- recover global color space setting
    if AdvancedShadingSetting == true then
      apollocore.Framework:SetCurrentAdvancedShading(false);
    end
  end
  return true;
end

function SceneLoader:UpdateSticker(spantime)
  local Sticker = self.sceneList[LAYER_STICKER];
  if Sticker then
    -- ensure sticker scene is running under correct AdvancedShading
    apollocore.Framework:SetCurrentAdvancedShading(Sticker.AdvancedShading == true);
    Sticker:Update(spantime);

    -- recover global color space setting
    if Sticker.AdvancedShading == true then
      apollocore.Framework:SetCurrentAdvancedShading(false);
    end
  end
end

--卸载贴纸
function SceneLoader:ReleaseSticker()
  local Sticker = self.sceneList[LAYER_STICKER];
  if Sticker then
    
    -- ensure sticker scene is released under correct AdvancedShading
    apollocore.Framework:SetCurrentAdvancedShading(Sticker.AdvancedShading == true);
    Sticker:ReleaseResource();

    -- recover global color space setting
    if Sticker.AdvancedShading == true then
      apollocore.Framework:SetCurrentAdvancedShading(false);
      apolloengine.DeviceResource:PushDeviceResource(
        defined.LAST_QUEUE_TEXTURE_STICKER,
        self.InputTex);
    end
  end
  self.sceneList[LAYER_STICKER] = nil;
  return true;
end

function SceneLoader:OnRecordStartSticker()
end

function SceneLoader:OnRecordStopSticker()
end


-----------------------------------------------------------------------美妆-----------------------------------------------------------------
--param: path  素材路径
--param: makeupType  美妆类型
function SceneLoader:LoadAsMakeup(path,makeupType)
end

function SceneLoader:UpdateMakeup(spantime)
end

--param: makeupType  美妆类型
function SceneLoader:ReleaseMakeup(makeupType)
end

function SceneLoader:OnRecordStartMakeup()
end

function SceneLoader:OnRecordStopMakeup()
end






--------------------------------------------------------------美颜-----------------------------------------------------------------------
function SceneLoader:UpdateFacebeauty(spantime)
end

function SceneLoader:ReleaseFacebeauty()
end

function SceneLoader:OnRecordStartFacebeauty()
end

function SceneLoader:OnRecordStopFacebeauty()
end



--------------------------------------------------------------风格滤镜-----------------------------------------------------------------------
function SceneLoader:UpdateStylish(spantime)
end

function SceneLoader:ReleaseStylish()
end

function SceneLoader:OnRecordStartStylish()
end

function SceneLoader:OnRecordStartStylish()
end




return SceneLoader;
