local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"


local Util = {}

function Util:ConstractRotationFromVector(VectorN,VectorT)
  local resultmat = nil;

  if VectorN:Dot(VectorT) ==0 then
    VectorBN = VectorN:Cross(VectorT);
    VectorBN:NormalizeSelf();
    resultmat = mathfunction.Matrix33(
          VectorN:x(),VectorN:y(),VectorN:z(),
          VectorT:x(),VectorT:y(),VectorT:z(),
          VectorBN:x(),VectorBN:y(),VectorBN:z()
      );
  else
    local costheta = VectorN:Dot(VectorT);
    VectorBN = VectorN:Cross(VectorT);
    VectorBN:NormalizeSelf();
    
    local VectorNTemp = VectorT:Cross(VectorBN);
    VectorNTemp:NormalizeSelf();
    
    resultmat = mathfunction.Matrix33(
          VectorNTemp:x(),VectorNTemp:y(),VectorNTemp:z(),
          VectorT:x(),VectorT:y(),VectorT:z(),
          VectorBN:x(),VectorBN:y(),VectorBN:z()
      );
  end

  return resultmat;
end

function Util:ConstractKinectRotationFromVector(VectorN,VectorT)
  local resultmat = nil;

  if VectorN:Dot(VectorT) ==0 then
    local VectorBN = VectorN:Cross(VectorT);
    VectorBN:NormalizeSelf();
    resultmat = mathfunction.Matrix33(
        -VectorBN:x(),-VectorBN:y(),-VectorBN:z(),
        VectorT:x(),VectorT:y(),VectorT:z(),
        VectorN:x(),VectorN:y(),VectorN:z()  
      );
  else
    local costheta = VectorN:Dot(VectorT);
    local VectorBN = VectorN:Cross(VectorT);
    VectorBN:NormalizeSelf();
    
    local VectorNTemp = VectorT:Cross(VectorBN);
    VectorNTemp:NormalizeSelf();
    
    resultmat = mathfunction.Matrix33(
        -VectorBN:x(),-VectorBN:y(),-VectorBN:z(),
        VectorT:x(),VectorT:y(),VectorT:z(),
        VectorNTemp:x(),VectorNTemp:y(),VectorNTemp:z()
      );
  end

  return resultmat;
end

function Util:OrthoNormalize(norm,tangent)
    norm:NormalizeSelf();
    tangent = tangent - norm * tangent:Dot(norm);
    tangent:NormalizeSelf();
    return norm,tangent;
end

function Util:FromToRotation(from,to)
	local w = from:Cross(to);
	local q = mathfunction.Quaternion( w.mx, w.my, w.mz, from:Dot(to));
	q.mw = q.mw + q:Length();
  q:NormalizeSelf();
  return q;
end

function Util:Limit1DOF(rotation,axis)
  return rotation * self:FromToRotation(axis * rotation, axis);
end

function Util:RemoveTwist(rotation, axis)
  local orthoAxis = mathfunction.vector3(axis.my, axis.mz, axis.mx);
  local normal = axis * rotation;
	local orthoTangent = orthoAxis;		
	local f = math.abs(normal:Dot(orthoTangent));
  if f > 0.98 then
    orthoAxis = axis:Cross(orthoAxis);
    orthoTangent = orthoAxis;
	end
	normal, orthoTangent = self:OrthoNormalize(normal, orthoTangent);

	local rotatedOrthoTangent = orthoAxis * rotation;
	normal, rotatedOrthoTangent = self:OrthoNormalize(normal, rotatedOrthoTangent);

	local fixedRotation = rotation * self:FromToRotation(rotatedOrthoTangent, orthoTangent);
  fixedRotation:NormalizeSelf();
  
  return fixedRotation;
end

function Util:Angle(quat1, quat2)
  quat1:NormalizeSelf();
  quat2:NormalizeSelf();
  local dot = quat1:Dot(quat2);
  local angle = 0.0;
  if dot < 1.0 - 0.000001 then
    angle = math.acos(math.min(math.abs(dot), 1.0)) * 2.0 * 180.0 / 3.1415926;
  end
  return angle;
end

return Util