local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local defined = require "apolloutility.defiend"
local keyboard = require "apolloengine.inputdelegate.keyboarddelegate"
local venusjson = require "venusjson"

local EffectKeyboardBehavior = venuscore.VenusBehavior:extend("EffectKeyboardBehavior");

local STATE_STOP = 0;
local STATE_PLAY = 1;

function EffectKeyboardBehavior:new()
    self.config = ""

    self.SceneSwitchAni = nil;
    self.SceneSwitchState = STATE_STOP;
    self.SceneSwitchTimer = -1;
    self.SceneSwitchAudio = nil;

    self.BackgroundLayerNode = nil;
    self.SceneSwithed = false;
    -- self.SceneSwitchRender = nil;
    -- self.SceneSwitchFGRender = nil;

    self.HeartEffectNode = nil;
    self.HeartEffectState = STATE_STOP;
    self.HeartEffectTimer = -1;

    self.NoteEffectNode = nil;
    self.NoteEffectState = STATE_STOP;
    self.NoteEffectTimer = -1;

    self.CrownShineAni = nil;
    self.CrownShineState = STATE_STOP;
    self.CrownShineTimer = -1;

    self.HeartBoomAni = nil;
    self.HeartBoomState = STATE_STOP;
    self.HeartBoomTimer = -1;

    self.inited = false
end

function EffectKeyboardBehavior:GetConfig()
    return self.config
end

function EffectKeyboardBehavior:SetConfig(config)
    self.inited = false
    self.config = config
end

function EffectKeyboardBehavior:_Init()
    local config_str = venusjson.LaodJsonFile(self.config)
    self.base = self.BackgroundLayerNode:GetNodeByName(config_str.base)
    self.Scene = config_str.init_scene

    self.targets = {}
    for _, v in ipairs(config_str.targets) do
        local back_node_list = {}
        local front_node_list = {}
        local is_active = (self.Scene == v.name)

        for _, name in ipairs(v.back_scene) do
            local node = self.BackgroundLayerNode:GetNodeByName(name)
            node.Active = is_active
            table.insert(back_node_list, node)
        end
        for _, name in ipairs(v.front_scene) do
            local node = self.BackgroundLayerNode:GetNodeByName(name)
            node.Active = is_active
            table.insert(front_node_list, node)
        end

        local target = {name = v.name, next = v.next, back_nodes = back_node_list, front_nodes = front_node_list}
        table.insert(self.targets, target)
    end

    self.inited = true
end

function EffectKeyboardBehavior:_OnStart()
    self.keyboard = function (key, status) self:OnKey(key, status) end
    keyboard:AddCallback(  self.keyboard);
end

function EffectKeyboardBehavior:_OnUpdate()
    if not self.inited then
        self:_Init()
    end

    local def = self:Timespan();

    if self.SceneSwitchTimer >= 0 then
        self.SceneSwitchTimer = self.SceneSwitchTimer + def;
        if self.SceneSwitchTimer > 0.5 and self.SceneSwitched == false then
            if self.Scene ~= nil then
                -- Find current node and deactivate
                for _, target in ipairs(self.targets) do
                    if self.Scene == target.name then
                        for _, node in ipairs(target.back_nodes) do
                            node.Active = false
                        end

                        for _, node in ipairs(target.front_nodes) do
                            node.Active = false
                        end

                        self.Scene = target.next
                        break
                    end
                end

                -- Find next node and activate
                for _, target in ipairs(self.targets) do
                    local name = target.name
                    if self.Scene == target.name then
                        for _, node in ipairs(target.back_nodes) do
                            node.Active = true
                        end

                        for _, node in ipairs(target.front_nodes) do
                            node.Active = true
                        end

                        break
                    end
                end
            end

            self.SceneSwitched = true

            -- matpath = "test:kiki/mat/bg.mat";
            -- local fgmatpath = "test:kiki/mat/fg.mat";
            -- if self.Scene == 1 then
            --     bgmatpath = "test:kiki/mat/bg_cloth.mat";
            --     fgmatpath = "test:kiki/mat/fg_cloth.mat";
            --     self.Scene = 2;
            -- elseif self.Scene == 2 then
            --     bgmatpath = "test:kiki/mat/bg_space.mat";
            --     fgmatpath = "test:kiki/mat/fg_space.mat";
            --     self.Scene = 3;
            -- else
            --     self.Scene = 1;
            -- end

            -- local materialEntity = apolloengine.MaterialEntity();
            -- local meta = apolloengine.MaterialMetadata(bgmatpath);
            -- materialEntity:PushMetadata(meta);
            -- materialEntity:CreateResource();
            -- self.SceneSwitchRender:ChangeMaterial(materialEntity, 1);

            -- materialEntity = apolloengine.MaterialEntity();
            -- meta = apolloengine.MaterialMetadata(fgmatpath);
            -- materialEntity:PushMetadata(meta);
            -- materialEntity:CreateResource();
            -- self.SceneSwitchFGRender:ChangeMaterial(materialEntity, 1);

            -- self.SceneSwitched = true;
        end
        if self.SceneSwitchTimer > 3 then
            self.SceneSwitchTimer = -1;
            local renderCmp = self.SceneSwitchAni:GetHostNode():GetComponent(apolloengine.Node.CT_RENDER);
            renderCmp:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
            self.SceneSwitchState = STATE_STOP;
        end
    end
    
    if self.HeartEffectTimer >= 0 then
        self.HeartEffectTimer = self.HeartEffectTimer + def;
        if self.HeartEffectTimer > 3 then
            self.HeartEffectTimer = -1;
            self.HeartEffectNode.Active = false;
            self.HeartEffectState = STATE_STOP;
        end
    end

    if self.NoteEffectTimer >= 0 then
        self.NoteEffectTimer = self.NoteEffectTimer + def;
        if self.NoteEffectTimer > 3 then
            self.NoteEffectTimer = -1;
            self.NoteEffectNode.Active = false;
            self.NoteEffectState = STATE_STOP;
        end
    end

    if self.CrownShineTimer >= 0 then
        self.CrownShineTimer = self.CrownShineTimer + def;
        if self.CrownShineTimer > 3 then
            self.CrownShineTimer = -1;
            local renderCmp = self.CrownShineAni:GetHostNode():GetComponent(apolloengine.Node.CT_RENDER);
            renderCmp:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
            self.CrownShineState = STATE_STOP;
        end
    end

    if self.HeartBoomTimer >= 0 then
        self.HeartBoomTimer = self.HeartBoomTimer + def;
        if self.HeartBoomTimer > 3 then
            self.HeartBoomTimer = -1;
            self.HeartBoomAni:Stop();
            self.HeartBoomAni:Reset();
            self.HeartBoomState = STATE_STOP;
        end
    end
end

function EffectKeyboardBehavior:OnKey(key, status)
    --S
    if key == 36 and status == 3 then
        if self.SceneSwitchAni and self.SceneSwitchState ~= STATE_PLAY then
            local renderCmp = self.SceneSwitchAni:GetHostNode():GetComponent(apolloengine.Node.CT_RENDER);
            renderCmp:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
            self.SceneSwitchAni:Play();
            self.SceneSwitchState = STATE_PLAY;
            self.SceneSwitchTimer = 0;
            self.SceneSwitched = false;
            if self.SceneSwitchAudio ~= nil then
                self.SceneSwitchAudio:Play();
            end
        end
    end
    --D
    if key == 21 and status == 3 then
        if self.HeartEffectNode and self.HeartEffectState ~= STATE_PLAY then
            self.HeartEffectNode.Active = true;
            self.HeartEffectState = STATE_PLAY;
            self.HeartEffectTimer = 0;
        end
    end
    --F
    if key == 23 and status == 3 then
        if self.NoteEffectNode and self.NoteEffectState ~= STATE_PLAY then
            self.NoteEffectNode.Active = true;
            self.NoteEffectState = STATE_PLAY;
            self.NoteEffectTimer = 0;
        end
    end
    --A
    if key == 18 and status == 3 then
        if self.CrownShineAni and self.CrownShineState ~= STATE_PLAY then
            local renderCmp = self.CrownShineAni:GetHostNode():GetComponent(apolloengine.Node.CT_RENDER);
            renderCmp:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
            self.CrownShineAni:Play();
            self.CrownShineState = STATE_PLAY;
            self.CrownShineTimer = 0;
        end
    end
    --Space
    if key == 19 and status == 3 then
        if self.HeartBoomAni and self.HeartBoomState ~= STATE_PLAY then
            self.HeartBoomAni:Play();
            self.HeartBoomState = STATE_PLAY;
            self.HeartBoomTimer = 0;
        end
    end
end

function EffectKeyboardBehavior:Timespan()
    if self.begintime == nil then
        self.begintime = venuscore.ITimerSystem:GetTimevalue();
    end

    local now = venuscore.ITimerSystem:GetTimevalue();
    local def = now - self.begintime;
    self.begintime = now;
    
    return def;
end

EffectKeyboardBehavior:MemberRegister("config",
    venuscore.ScriptTypes.FilePathType(
        {"json"},
        EffectKeyboardBehavior.GetConfig,
        EffectKeyboardBehavior.SetConfig
    )
)

EffectKeyboardBehavior:MemberRegister("SceneSwitchAni",
    venuscore.ScriptTypes.ReferenceType(
        apolloengine.FrameAnimationComponent:RTTI()
));

EffectKeyboardBehavior:MemberRegister("HeartEffectNode",
    venuscore.ScriptTypes.ReferenceType(
        apolloengine.Node:RTTI()
));

EffectKeyboardBehavior:MemberRegister("NoteEffectNode",
    venuscore.ScriptTypes.ReferenceType(
        apolloengine.Node:RTTI()
));

EffectKeyboardBehavior:MemberRegister("CrownShineAni",
    venuscore.ScriptTypes.ReferenceType(
        apolloengine.FrameAnimationComponent:RTTI()
));

EffectKeyboardBehavior:MemberRegister("BackgroundLayerNode",
    venuscore.ScriptTypes.ReferenceType(
        apolloengine.Node:RTTI()
));

-- EffectKeyboardBehavior:MemberRegister("SceneSwitchRender",
--     venuscore.ScriptTypes.ReferenceType(
--         apolloengine.RenderComponent:RTTI()
-- ));

-- EffectKeyboardBehavior:MemberRegister("SceneSwitchFGRender",
--     venuscore.ScriptTypes.ReferenceType(
--         apolloengine.RenderComponent:RTTI()
-- ));

EffectKeyboardBehavior:MemberRegister("HeartBoomAni",
    venuscore.ScriptTypes.ReferenceType(
        apolloengine.FrameAnimationComponent:RTTI()
));

EffectKeyboardBehavior:MemberRegister("SceneSwitchAudio",
    venuscore.ScriptTypes.ReferenceType(
        apolloengine.AudioComponent:RTTI()
));

return EffectKeyboardBehavior;