local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

--local collisionhandler = require "behavior.vtuber_behavior.collisionhandler"
local cv = require "computervisionfunction"
local skeletonnode = require "behavior.vtuber_behavior.skeleton_node"
local laplacianvp =  require "behavior.vtuber_behavior.laplacian_virtualpoint"
local libkinect = require "libkinect"
local libmasquerade = require "libmasquerade"
local lowpassfilter = require "avatar.filter.lowpassfilter"
local postsolver = require "behavior.vtuber_behavior.solver"
local Keyboard = require "apolloengine.inputdelegate.keyboarddelegate"

local skelScriptPath = "scrs:behavior/vtuber_behavior/skeleton_behavior.lua"
local handAnimScriptPath = "scrs:behavior/vtuber_behavior/hand_putup_behavior.lua"

local Avatar = venuscore.VenusBehavior:extend("Avatar"); 

function Avatar:OnKey(key,status)
  LOG("KEY "..key.." STATUS IS "..status);
end

function Avatar:new()
    self.skeBehvr = nil;
    self.recogition=nil;
    
    self.postprocess = true;
    self.postprocess2nd = 1;
    self.usekinectrotate = false;
    self.useRotationLimit = false;
    self.useupdate  = true;
    self.enablecollision  = true;
    self.itercount  = 10;
    self.usewarmup = false;
    self.enablefilter  = true;
    self.correctTwist  = true;
    self.isKinectInited = false;
    self.isSmoothed = true;
    self.useFinalFilter = true;
    self.SkeletonTracking = libkinect.SkeletonTracking();
    
    self.lastLocalRot1 = {};
    self.lastLocalRot2 = {};
    
    self.handAnimBehvr = nil;
end



function Avatar:GetRecongition()

    if self.recognition == nil then
      return nil, nil, nil;
    end
    local results = self.recognition:GetResult();
    if results == nil or
       results[128] == nil or
       results[256] == nil then
        return nil, nil, nil
    end
    
    local pose2d_raw = results[128][1]; -- x1, y1, score1, x2, y2, score2, ...
    local pose3d_raw = results[256][1]; -- x1, y1,     z1, x2, y2,     z2, ...
    local pose2d_ret = {};
    local score_ret = {};
    local pose3d_ret = {};
    for i = 1, 14 do
        pose2d_ret[i] = {pose2d_raw[(i-1)*3+1], pose2d_raw[(i-1)*3+2]};
        score_ret[i] = pose2d_raw[(i-1)*3+3];
        pose3d_ret[i] = {pose3d_raw[(i-1)*3+1], pose3d_raw[(i-1)*3+2], pose3d_raw[(i-1)*3+3]};
    end
    return pose2d_ret, score_ret, pose3d_ret;
end

function Avatar:_SetupIK()
  --初始化IK
    local ikcomp = self.boneNodesPose["Pelvis"]:GetComponent(apolloengine.Node.CT_KINEMATICS);
    if ikcomp == nil then
      ikcomp = self.boneNodesPose["Pelvis"]:CreateComponent(apolloengine.Node.CT_KINEMATICS);
      ikcomp.SolverType = apolloengine.InverseKinematicsComponent.SolverJacobian;
    end
    self.ikJoints = {"R_Shoulder","R_Elbow","L_Shoulder","L_Elbow","R_Hip","R_Knee","L_Hip","L_Knee"};
    
    
    self.skeletonNodeIK:CreateJoint("Pelvis", -30, 30, -360, 360, -30, 30);  
    self.skeletonNodeIK:CreateJoint("R_Shoulder", -30, 30, -100, 100, -30, 30);  
    self.skeletonNodeIK:CreateJoint("R_Elbow", -30, 30, 0, 150, 0, 0 );  
    self.skeletonNodeIK:CreateJoint("R_Wrist", 0, 0, 0, 0, 0, 0);  
    --self.skeletonNodeIK:CreateJoint("R_Hand", 0, 0, -90, 90, -90, 90);  
    self.skeletonNodeIK:CreateJoint("L_Shoulder", -30, 30, -100, 100, -30, 30);
    self.skeletonNodeIK:CreateJoint("L_Elbow", -30, 30, -150, 0, 0, 0);  
    self.skeletonNodeIK:CreateJoint("L_Wrist", 0, 0, 0, 0, 0, 0); 
    --self.skeletonNodeIK:CreateJoint("L_Hand", 0, 0, -90, 90, -90, 90);  
    self.skeletonNodeIK:CreateJoint("R_Hip", -90, 90, -20, 20, -30, 30);  
    self.skeletonNodeIK:CreateJoint("R_Knee", 0, 150, 30, 30, 0, 0);  
    self.skeletonNodeIK:CreateJoint("R_Ankle", 0, 0, 0, 0, 0, 0);  
    self.skeletonNodeIK:CreateJoint("L_Hip", -90, 90, -20, 20, -30, 30);  
    self.skeletonNodeIK:CreateJoint("L_Knee", 0, 150, 30, 30, 0, 0);  
    self.skeletonNodeIK:CreateJoint("L_Ankle", 0, 0, 0, 0, 0, 0);  
    self.skeletonNodeIK:CreateJoint("Neck", 0, 0, 0, 0, 0, 0);  
    self.skeletonNodeIK:CreateJoint("Head", 0, 0, 0, 0, 0, 0);  

      
    self.skeletonNodeIK:LinkJoints("Pelvis","L_Shoulder");
    self.skeletonNodeIK:LinkJoints("L_Shoulder","L_Elbow");
    self.skeletonNodeIK:LinkJoints("L_Elbow","L_Wrist");
   -- self.skeletonNodeIK:LinkJoints("L_Wrist","L_Hand");


    self.skeletonNodeIK:LinkJoints("Pelvis","R_Shoulder");
    self.skeletonNodeIK:LinkJoints("R_Shoulder","R_Elbow");
    self.skeletonNodeIK:LinkJoints("R_Elbow","R_Wrist");
   -- self.skeletonNodeIK:LinkJoints("R_Wrist","R_Hand");
 
    self.skeletonNodeIK:LinkJoints("Pelvis","L_Hip");
    self.skeletonNodeIK:LinkJoints("L_Hip","L_Knee");
    self.skeletonNodeIK:LinkJoints("L_Knee","L_Ankle");
    
    self.skeletonNodeIK:LinkJoints("Pelvis","R_Hip");
    self.skeletonNodeIK:LinkJoints("R_Hip","R_Knee");
    self.skeletonNodeIK:LinkJoints("R_Knee","R_Ankle");
    
    self.skeletonNodeIK:LinkJoints("Pelvis","Neck");
    self.skeletonNodeIK:LinkJoints("Neck","Head");
    
    self.skeletonNodeIK:SetTarget(self.boneNodes);
end

function Avatar:_InitSkeleton(onIK)
  self.boneNodes = self.skeBehvr:GetJoints();  
  self.skeletonNode = skeletonnode()
  self.skeletonNode:SetBonesRef(self.boneNodes);
  local rootBone,spineBones,bonesNames,children,bodyPair = self.skeBehvr:GetJointConfig();
  self.skeletonNode:SetPoseEstimateBoneNames(rootBone,spineBones,bonesNames,children,bodyPair);
  self.skeletonNode:BindPose();
  --self.skeletonNode:InitCollision(self.skeBehvr:GetColliders());
  
  if onIK then
    self.boneNodesPose = self.skeBehvr:GetIKJoints();
    self.skeletonNodeIK = skeletonnode();
    self.skeletonNodeIK:SetBonesRef(self.boneNodesPose);
    self.skeletonNodeIK:SetPoseEstimateBoneNames(self.skeBehvr:GetJointConfig());
    self.skeletonNodeIK:BindPose();
    --self.skeletonNodeIK:InitCollision(self.skeBehvr:GetColliders());
    self:_SetupIK();
  end
end

function Avatar:_UpdateSkeleton(pos3d, cameraT,ignorehand,spinerot)
  self.skeletonNode:UpdateSkeleton(pos3d,cameraT,ignorehand,spinerot);
  self.skeletonNode:CorrectArmsTwist(self.lastLocalRot1);
end

function Avatar:_UpdateSpineByRot(rot3d,pos3d)
  self.skeletonNode:UpdateSpineByRot(rot3d,pos3d);
end

function Avatar:_UpdateRotate(rot3d,pos3d)
   self.skeletonNode:UpdateSkeletonByRot(rot3d,pos3d);
end

function Avatar:_UpdateSkeletonFromCurPosition(pos3d)
  self.skeletonNode:UpdateSkeletonFromCurPosition(pos3d);
end

function Avatar:_UpdateIK(cameraT,scores)
  if self.skeletonNodeIK then
    local curtargets,rootRot = self.skeletonNode:GetTargets()
    self.skeletonNodeIK:UpdateIK(rootRot,cameraT,scores);
    for i = 1, #self.ikJoints do
      local myJoint = self.skeletonNode  :GetJoint(self.ikJoints[i]).trans;
      local ikJoint = self.skeletonNodeIK:GetJoint(self.ikJoints[i]).trans;
      myJoint:SetLocalRotation(ikJoint:GetLocalRotation());
    end
  end
end

function Avatar:_GetSkeletonNode()
  return self.skeletonNode;
end

function Avatar:_OnAwake()

    self._isInit = false;

    local scriptCom = self.Node:GetComponent(apolloengine.Node.CT_SCRIPT);
    if scriptCom ~= nil then
        for sckey, scvalue in pairs(scriptCom.Instances) do
            if sckey == skelScriptPath then
                self.skeBehvr = scvalue;
                break;
            end
        end
    else
        return;
    end
    
    if self.skeBehvr == nil then
      return;
    end
    
    local onIK = false;
    self:_InitSkeleton(onIK);
    self.testpose = {};
    self.testrot = {};
    --collisionhandler:Init(self:_GetSkeletonNode());
    postsolver:init();
    lowpassfilter:Initialize(0,3.0,1.0,2.0);
    
    if self.isKinectInited ~= true then
      if not self:KinectInit(true) then
        return;
      end
    end

end


function Avatar:_OnStart()
  self.keyboard = function (key,status) self:OnKey(key,status) end
    Keyboard:AddCallback(  self.keyboard);
    LOG("******** ADD A CALLBACK888");
end
function Avatar:KinectInit()
  if self.SkeletonTracking and self.SkeletonTracking:Init(self.isSmoothed) == 0 then
    LOG("[KINECT]: INIT DONE");
    self.isKinectInited = true;
    return true;
  else
    self.isKinectInited = false;
    ERROR("[KINECT]: fail to init kinect");
  end
  return false;
end

function Avatar:_OnUpdate(def)
 
  local pos2d, scores, pos3d = self:GetRecongition();
  local rot3d = nil;
  local spinepos3d = nil;
  local spinerot3d = nil;
  
 self.testheadrot = nil;
  if self.Tracking then
    local headrot3d = self.Tracking:GetRotation();
     self.testheadrot = {};
    for index, rot in pairs(headrot3d) do
      self.testheadrot[index] = rot;
    end
  end
  if self.useupdate then
    self.testpose = {};
    self.testrot = {};
    if self.isKinectInited and self.SkeletonTracking:Track() == 0 then
      local datajoints = self.SkeletonTracking:GetJoints();
      local dataorients = self.SkeletonTracking:GetOrients();

      for index, point in pairs(datajoints) do
        self.testpose[index] = {point[1], point[2], point[3]};
      end

      for index, quaternion in pairs(dataorients) do
        self.testrot[index] = {quaternion[1], quaternion[2], quaternion[3], quaternion[4]};
      end
    end
    if  #self.testpose<22 or #self.testrot<22 then 
      if self.JsonPoseGetter~=nil then
        local script =  self.JsonPoseGetter.Instances["scrs:behavior/vtuber_behavior/json_pose_getter.lua"];
        self.testpose,self.testrot = script:Estimate(not self.useupdate);
      else
        return;
      end
    end
    if self.testheadrot~= nil then
      self.testrot[25] = self.testheadrot;
    end
  end

  pos3d = {};
  rot3d = {};
  spinepos3d = {};
  spinerot3d = {};
  for i=1,22 do
    pos3d[i] = self.testpose[i+3];
    rot3d[i] = self.testrot[i+3];
  end

  for i=1,3 do
    spinepos3d[i] = self.testpose[i];
    spinerot3d[i] = self.testrot[i];
  end
  
  spinepos3d[4] = self.testpose[24];
  spinerot3d[4] = self.testrot[24];
  spinepos3d[5] = self.testpose[25];
  spinerot3d[5] = self.testrot[25];
  
  local headlength = math.sqrt( math.pow((pos3d[22][1]-pos3d[21][1]),2)+  math.pow((pos3d[22][2]-pos3d[21][2]),2)+math.pow((pos3d[22][3]-pos3d[21][3]),2));
  laplacianvp:SetHeadSize(headlength,headlength,headlength);
  laplacianvp:SetHeadTransform(pos3d[22],rot3d[22]);
  
  local bodyupwidth = math.sqrt( math.pow((pos3d[1][1]-pos3d[7][1]),2)+  math.pow((pos3d[1][2]-pos3d[7][2]),2)+math.pow((pos3d[1][3]-pos3d[7][3]),2));
  local bodylowerwidth = math.sqrt( math.pow((pos3d[13][1]-pos3d[17][1]),2)+  math.pow((pos3d[13][2]-pos3d[17][2]),2)+math.pow((pos3d[13][3]-pos3d[17][3]),2));
  local bodyavgwidth = (bodyupwidth+bodylowerwidth)/2;
  
  laplacianvp:SetBodySize(bodyavgwidth,bodyavgwidth,bodyavgwidth/4);
  laplacianvp:SetBodyTransform(spinepos3d[2],spinerot3d[2]);
  
  laplacianvp:SetVirtualPointsSplit(2);
  local vps = laplacianvp:GetVirtualPoints();
  for i=1,#vps do
    pos3d[22+i] = vps[i];
  end
  if pos3d==nil then
    LOG("no 3d pose data input!")
    return;
  end

  if self.lastroot==nil then
    self.lastroot = {0,0,-4}
  end

  cameraT = mathfunction.vector3(self.lastroot[1],self.lastroot[2],self.lastroot[3]);
 
 
  self:_UpdateSkeleton(pos3d, cameraT,true,spinerot3d);
  --if self.usekinectrotate then
  --  self:_UpdateRotate(rot3d,pos3d);
  --end

  if self.usekinectrotate then
    self.skeletonNode:UpdateArmRot_R(rot3d,pos3d,self.useRotationLimit);
    self.skeletonNode:UpdateArmRot_L(rot3d,pos3d,self.useRotationLimit);
  end

  if self.postprocess==false then
    return;
  end
  
  local modelpose = self:_GetSkeletonNode():GetCurrentPose();
  if self.skeBehvr:GetLaplacianExtras()~=nil then 
    self:_GetSkeletonNode():SetLaplacianExtras(self.skeBehvr:GetLaplacianExtras());
    local extrapose = self:_GetSkeletonNode():GetLaplacianExtraPose();
    for i=1,#extrapose do
      modelpose[22+i] = extrapose[i];
    end
  end
  
  
  postsolver:resetcapsule();
  
  if self.enablecollision then
    local headtrans = self:_GetSkeletonNode():GetJoint("Head").trans;
    local headrelativepos = mathfunction.vector3(modelpose[22][1],modelpose[22][2],modelpose[22][3]);
    local pointa = headrelativepos+ mathfunction.vector3(0.107,0.3435,0.05)*headtrans:GetWorldRotation();
    local pointb = headrelativepos+ mathfunction.vector3(-0.107,0.3435,0.05)*headtrans:GetWorldRotation();
    local radius = 0.3750;
    
    postsolver:addcapsule(pointa,pointb,radius);
    
    local spinemidpose = self:_GetSkeletonNode():GetSpineMidPose();
    local bodytrans = self:_GetSkeletonNode():GetJoint("Spinemid").trans;
    local spinemidrelativepos = mathfunction.vector3(spinemidpose[1],spinemidpose[2],spinemidpose[3]);
    local bodya = spinemidrelativepos+ mathfunction.vector3(0,0.0264,0)*bodytrans:GetWorldRotation();
    local bodyb = spinemidrelativepos+ mathfunction.vector3(0,-0.0264,0)*bodytrans:GetWorldRotation();
    local bodyradius = 0.21;
    
    postsolver:addcapsule(bodya,bodyb,bodyradius);
  end
  local rwrist = self:_GetSkeletonNode():GetJoint("R_Wrist").trans;
  local lwrist = self:_GetSkeletonNode():GetJoint("L_Wrist").trans;
  postsolver:clearbindsphere()
  postsolver:addbindsphere(2,1,0.06,mathfunction.vector3(),mathfunction.Quaternion())
  postsolver:addbindsphere(3,2,0.107,mathfunction.vector3(0.0424,-0.02,0.0),rwrist:GetWorldRotation())
  postsolver:addbindsphere(8,7,0.06,mathfunction.vector3(),mathfunction.Quaternion())
  postsolver:addbindsphere(9,8,0.107,mathfunction.vector3(-0.0424,-0.02,0.0),lwrist:GetWorldRotation())
  
  postsolver.iterationcount = self.itercount;
  postsolver.usewarmup = self.usewarmup;

  local finalpos = postsolver:solve(pos3d,modelpose);
  if self.enablefilter then
    finalpos = lowpassfilter:Filter(finalpos);
  end
  self:_UpdateSkeletonFromCurPosition(finalpos);
  --self:_UpdateSkeleton(finalpos, cameraT,true,spinerot3d);
  if self.correctTwist then
    self.skeletonNode:CorrectArmsTwist({});
  end

  if self.useFinalFilter then
    self.skeletonNode:FilterArmsTwist();
  end
  

  if self.handAnimBehvr == nil then
    local scriptCom = self.Node:GetComponent(apolloengine.Node.CT_SCRIPT);
    if scriptCom ~= nil then
      for sckey, scvalue in pairs(scriptCom.Instances) do
        if sckey == handAnimScriptPath then
          self.handAnimBehvr = scvalue;
          break;
        end
      end
    end  
  end

  if self.handAnimBehvr ~= nil then
    local transLeftHand = self:_GetSkeletonNode():GetJoint("L_Hand").trans;
    local transRightHand = self:_GetSkeletonNode():GetJoint("R_Hand").trans;
    local posLeftHand = transLeftHand:GetWorldPosition();
    local posRightHand = transRightHand:GetWorldPosition();
    local posNeck = self:_GetSkeletonNode():GetJoint("Neck").trans:GetWorldPosition();
    local posPelvis = self:_GetSkeletonNode():GetJoint("Pelvis").trans:GetWorldPosition();
    local dot1 = (posLeftHand - posNeck):Dot(posPelvis-posNeck);
    local dot2 = (posRightHand- posNeck):Dot(posPelvis-posNeck);
    if dot1 < 0 then
      self.handAnimBehvr:Play(true);
      local position = posLeftHand;
      self.handAnimBehvr:UpdatePosition(position,true);
    else
      self.handAnimBehvr:Stop(true);
    end
    if dot2 < 0 then
      self.handAnimBehvr:Play(false);
      local position = posRightHand;
      self.handAnimBehvr:UpdatePosition(position,false);
    else
      self.handAnimBehvr:Stop(false);
    end  
  end

end

Avatar:MemberRegister("ModelPoseGetter",
venuscore.ScriptTypes.ReferenceType(
apolloengine.ScriptComponent:RTTI()
)); 

 Avatar:MemberRegister("JsonPoseGetter",
 venuscore.ScriptTypes.ReferenceType(
 apolloengine.ScriptComponent:RTTI()
 )); 

Avatar:MemberRegister("recognition",
  venuscore.ScriptTypes.ReferenceType(
    cv.RecognitionComponent:RTTI(),
    Avatar.recognition,
    Avatar.recognition 
)); 

Avatar:MemberRegister("Tracking",
  venuscore.ScriptTypes.ReferenceType(
    libmasquerade.TrackingComponent:RTTI()
));

Avatar:MemberRegister("postprocess");

Avatar:MemberRegister("enablecollision");

Avatar:MemberRegister("itercount");

Avatar:MemberRegister("usewarmup");

Avatar:MemberRegister("enablefilter");

Avatar:MemberRegister("correctTwist");

Avatar:MemberRegister("postprocess2nd");

Avatar:MemberRegister("useupdate");

Avatar:MemberRegister("usekinectrotate");

Avatar:MemberRegister("useRotationLimit");

Avatar:MemberRegister("useFinalFilter");
return Avatar;