local Object = require "classic"
local FrameCountdown = require "behavior.tracking_behavior.frame_countdown"

local Freezer = Object:extend()

local STATE = {
  FREEZING = 0,
  FREEZED = 1,
  UNFREEZING = 2,
  UNFREEZED = 3
}

function Freezer:new(count)  
  self.unfreeze_countdown = FrameCountdown(10)
  self.freeze_countdown = FrameCountdown(10)
  self.state = STATE.UNFREEZED
end

function Freezer:Freeze(active)
  if active and self.state ~= STATE.FREEZED then
    self.state = STATE.FREEZING
  elseif not active and self.state ~= STATE.UNFREEZED then
    self.state = STATE.UNFREEZING
  end
end

function Freezer:Process(weight_dict)
  local res = weight_dict
  if self.state == STATE.FREEZING then
    self.freeze_countdown:Start()
    res = weight_dict
  elseif self.state == STATE.FREEZED and not self.freeze_countdown:Finished() then
    local progress = self.freeze_countdown:Progress()
    for name, w in pairs(weight_dict) do
      res[name] = weight_dict[name] * (1 - progress)
    end
    self.freeze_countdown:Update()
  elseif self.state == STATE.FREEZED then
    for name, w in pairs(weight_dict) do
      res[name] = 0
    end
  elseif self.state == STATE.UNFREEZING then
    self.unfreeze_countdown:Start()
    for name, w in pairs(weight_dict) do
      res[name] = 0
    end
  elseif not self.unfreeze_countdown:Finished() then
    local progress = self.unfreeze_countdown:Progress()
    for name, w in pairs(weight_dict) do
      res[name] = weight_dict[name] * progress
    end
    self.unfreeze_countdown:Update()
  end
  return res
end

function Freezer:Update()
  if self.state == STATE.FREEZING then
    self.state = STATE.FREEZED
  elseif self.state == STATE.UNFREEZING then
    self.state = STATE.UNFREEZED
  end
end

return Freezer