local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local quatfilter = require "math.lowpassfilter.oneeurofilter_quat"
local AttachBehavior = venuscore.VenusBehavior:extend("AttachBehavior"); 
local cv = require "computervisionfunction"
local PoseScriptBehavior = "scrs:behavior/avatar_behavior/avatardepth_behavior.lua"
local PoseAvatarScriptBehavior = "scrs:behavior/avatar_behavior/avatar_behavior.lua"
local PoseAttachBehavior = "scrs:behavior/avatar_behavior/attach_behavior.lua"


function AttachBehavior:new()
    self.SmoothFactorA  = 3;   
    self.SmoothFactorB  = 1; 
    self.SmoothFactorC  = 2; 
    self.UseSmoothFilter = true;
    self.UseFaceRecognition = false;
    self.AttachIdx = 13;
    self.AttachType = 1;
    self.AttachObj = nil;
    self.HeadOffset = mathfunction.vector3(0.,-0.35,-0.1)
    self.PoseScript = nil;
    self.Head = nil;
    self.recognition = nil;
    self.maskNode = nil;
    
    self.starTime = venuscore.ITimerSystem:GetTimevalue();
    
    self.poseweight = 0.5;
    self.weightspeed = 2.0;
    self.lastDetected = false;
end

function AttachBehavior:GetAttachIdx()
  return self.AttachIdx;
end

function AttachBehavior:SetAttachIdx(idx)
  self.AttachIdx = idx;
end

function AttachBehavior:GetAttachType()
  return self.AttachType;
end

function AttachBehavior:SetAttachType(atttype)
  self.AttachType = atttype;
end

function AttachBehavior:_OnAwake()

end

function AttachBehavior:Lerp(transa,rota,transb,rotb,weight)
  if transa == nil and transb ~=nil then
    return transb,rotb;
  elseif transa ~= nil and transb == nil then
    return transa,rota;
  elseif transa==nil and transb==nil then
    return nil, nil;
  end
  local finaltrans = mathfunction.vector3();
  local finalrot;
  local finalx = weight*transb:x()+(1-weight)*transa:x();
  local finaly = weight*transb:y()+(1-weight)*transa:y();
  local finalz = weight*transb:z()+(1-weight)*transa:z();
  finaltrans:Set(finalx,finaly,finalz);
  finalrot = mathfunction.Mathutility:Slerp(rota,rotb,weight);
  return finaltrans,finalrot;
end

function AttachBehavior:IsValidFace(facedata)
  --[==[
  local left_eye_out  = {facedata[53*2-1], facedata[53*2]} --左眼外角
  local left_eye_in   = {facedata[56*2-1], facedata[56*2]} --左眼内角
  local right_eye_out = {facedata[62*2-1], facedata[62*2]} --右眼外角
  local right_eye_in  = {facedata[59*2-1], facedata[59*2]} --右眼内角
  local nose          = {facedata[47*2-1], facedata[47*2]} --鼻子
  --]==]
  -- 110 is the offset to visibility
  local vis_left_eye_out  = facedata[(110+53)*2-1];
  local vis_left_eye_in   = facedata[(110+56)*2-1];
  local vis_right_eye_out = facedata[(110+62)*2-1];
  local vis_right_eye_in  = facedata[(110+59)*2-1];
  local vis_nose          = facedata[(110+47)*2-1];

  local roll  = facedata[217];
  local yaw   = facedata[219];
  local pitch = facedata[221];
  --LOG(roll, yaw, pitch)
  
  local ret = true;
  if   (yaw   > 45) or (yaw   < -45)
    or (pitch > 45) or (pitch < -45) then
    -- or (vis_left_eye_out  == 0) or (vis_left_eye_in  == 0)
    -- or (vis_right_eye_out == 0) or (vis_right_eye_in == 0)
    -- or (vis_nose == 0) then
    ret = false;
  end
  return ret;
end

function AttachBehavior:_OnUpdate(def)
  
  self:GetAttachObject();
  
  if venuscore.isNil(self.AttachObj) then
    return
  end
  LOG("update attacher is "..self.Node:GetName())
  local posebehavior = nil;
  if not venuscore.isNil(self.PoseScript)  then
    posebehavior =  self.PoseScript.Instances[PoseScriptBehavior];
    if posebehavior == nil and not venuscore.isNil(self.PoseScript) then
      posebehavior =  self.PoseScript.Instances[PoseAvatarScriptBehavior];
    end
  end
  
  local isPoseDetected = false;
  local isBack = false;

  if posebehavior then
    self.recognition = posebehavior.recognition;
    isPoseDetected = not(posebehavior:IsLessScore()) and  posebehavior:GetTransform(self.AttachIdx).active;
    isBack = posebehavior:IsBack();
  end
  
  self.facedetected = false;
  if self.recognition then
    local results = self.recognition:GetResult();
    if results[1]==nil or #results[1] == 0 then

    else
      self.facedetected = self:IsValidFace(results[1][1]);
    end
  end
  self.facedetected = self.facedetected and self.UseFaceRecognition;

  if isBack then
    isPoseDetected =false;
    self.facedetected = false;
  end

  if not self.facedetected then
    self.lastheadtrans = nil;
    self.lastheadrot = nil;
  end
  if not isPoseDetected then
    self.lastbodytrans = nil;
    self.lastbodyrot = nil;
  end

  if self.maskNode then
    if isPoseDetected==false and self.facedetected then
      self.maskNode.Active = true;    
    else
      if self.poseweight > 0.99 then
        self.maskNode.Active = false;
      end    
    end
  end
  self:UpdatePoseWeight(isPoseDetected, self.facedetected, def);

  local headtrans = nil;
  local headrot = nil;
  local bodytrans = nil;
  local bodyrot = nil;
  
  if self.Head then
    self.Head:GetHostNode().Active = true;
  end

  if  self.facedetected==false and isPoseDetected== false then
    self.AttachObj:GetHostNode().Active = false;
    return;
  else
    self.AttachObj:GetHostNode().Active = true;
  end

  if self.facedetected==false then 
    headtrans = self.lastheadtrans;
    headrot = self.lastheadrot;
  else
    headtrans = self.Head:GetWorldPosition() + self.HeadOffset*self.Head.LocalRotation;
    headrot = self.Head.LocalRotation;
  end
  
  if isPoseDetected== false then
    bodytrans = self.lastbodytrans;
    bodyrot = self.lastbodyrot;
  else
    local transform = posebehavior:GetTransform(self.AttachIdx);
    bodytrans = transform.position;
    bodyrot = transform.rotation;
  end

  local finaltrans,finalrot = self:Lerp(headtrans,headrot,bodytrans,bodyrot,self.poseweight);
  -- ERROR("POSE WEIGHT IS "..self.poseweight);
  if finaltrans~=nil and finalrot~=nil then
    
    if self.AttachType == 1 then
      if finalrot.mx ~= finalrot.mx or finalrot.my ~= finalrot.my or 
          finalrot.mz ~= finalrot.mz or finalrot.mw ~= finalrot.mw then
       
      else
        self:UpdateWingsRotation(finalrot);
      end
    end
    
    self.AttachObj:SetWorldPosition(finaltrans);
    -- ERROR(finaltrans)
    -- ERROR(finalrot)
    -- self.lasttrans = finaltrans;
    -- self.lastrot = finalrot;
  end

  self.lastheadtrans = headtrans;
  self.lastheadrot = headrot;
  self.lastbodytrans = bodytrans;
  self.lastbodyrot = bodyrot;
end

function AttachBehavior:UpdateWingsRotation(rot)
  
  if self.UseSmoothFilter then
    if self.quatFilter == nil then    
      self.quatFilter = quatfilter(venuscore.ITimerSystem:GetTimevalue() - self.starTime,rot,self.SmoothFactorA,self.SmoothFactorB,self.SmoothFactorC);
    else
      rot = self.quatFilter:filter(venuscore.ITimerSystem:GetTimevalue() - self.starTime, rot);
    end
  end
  self.AttachObj:SetWorldRotation(rot)
end

function AttachBehavior:UpdatePoseWeight(isPoseDetected, isFaceDetected,time)

  if isPoseDetected==false and isFaceDetected==true then
    if self.lastDetected then
      self.poseweight = self.poseweight - time*self.weightspeed;
    else
      self.poseweight = 0;
    end
  elseif  isPoseDetected==true then
    if self.lastDetected then
      self.poseweight = self.poseweight + time*self.weightspeed;
    else
      self.poseweight = 1;
    end
  end
  
  self.lastDetected = isPoseDetected or isFaceDetected;
  
  if self.poseweight then
    if self.poseweight>1 then
      self.poseweight = 1;
    elseif self.poseweight<0 then
      self.poseweight = 0;
    end
  end
  
end


function AttachBehavior:GetPoseScript()
    return self.PoseScript;
end

function AttachBehavior:SetPoseScript(value)
  self.PoseScript = value;

end


function AttachBehavior:GetHeadOffset()
    return self.HeadOffset
end

function AttachBehavior:SetHeadOffset(value)
    self.HeadOffset = value
end

function AttachBehavior:GetAttachObject()
  if not venuscore.isNil(self.AttachObj) and self.AttachObj:GetHostNode():GetRoot()~=self.Node then
    self.AttachObj = nil;
  end
  if venuscore.isNil(self.AttachObj) then
    
    local children = self.Node:GetChildrens();
    for i=1,#children do
      local child = children[i];
      
      local script =  child:GetComponent(apolloengine.Node.CT_SCRIPT);
      local canbeattach = true;
      if script then
         
        local scriptinstance = script.Instances[PoseAttachBehavior];
        for key,value in pairs(script.Instances) do
          if string.find(key, "attach_behavior.lua")~=nil then
            canbeattach = false;
           
          end
        end
      end
      if canbeattach then
        self.AttachObj = child:GetComponent(apolloengine.Node.CT_TRANSFORM);
        return;
      end
    end
  end
end

AttachBehavior:MemberRegister("PoseScript",
    venuscore.ScriptTypes.ReferenceType(
    apolloengine.ScriptComponent:RTTI(),
    AttachBehavior.GetPoseScript,
    AttachBehavior.SetPoseScript),
   "none"
);

AttachBehavior:MemberRegister("AttachObj",
    venuscore.ScriptTypes.ReferenceType(
    apolloengine.TransformComponent:RTTI()),
  "none"
);


AttachBehavior:MemberRegister(
    "AttachIdx",  
    venuscore.ScriptTypes.ComboType(
        {
            {
                key = "right shoulder",
                value = 1
            },
            {
                key = "right elbow",
                value = 2
            },
            {
                key = "right wrist",
                value = 3
            },
            {
                key = "left shoulder",
                value = 4
            },
            {
                key = "left elbow",
                value = 5
            },
            {
                key = "left wrist",
                value = 6
            },
            {
                key = "right hip",
                value = 7
            },
            {
                key = "right knee",
                value = 8
            },
            {
                key = "right foot",
                value = 9
            },
            {
                key = "left hip",
                value = 10
            },
            {
                key = "left knee",
                value = 11
            },
            {
                key = "left foot",
                value = 12
            },
            {
                key = "pelvis",
                value = 13
            },
            {
                key = "none",
                value = 14
            },
        },
        AttachBehavior.GetAttachIdx,
        AttachBehavior.SetAttachIdx
    ),
    "none"
);

AttachBehavior:MemberRegister(
    "AttachType",  
    venuscore.ScriptTypes.ComboType(
        {
            {
                key = "postion&rotation",
                value = 1
            },
            {
                key = "postion",
                value = 2
            },
        },
        AttachBehavior.GetAttachType,
        AttachBehavior.SetAttachType
    )
);


AttachBehavior:MemberRegister("UseSmoothFilter");
AttachBehavior:MemberRegister("SmoothFactorA");
AttachBehavior:MemberRegister("SmoothFactorB");
AttachBehavior:MemberRegister("SmoothFactorC");
AttachBehavior:MemberRegister("UseFaceRecognition");


AttachBehavior:MemberRegister("Head",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.TransformComponent:RTTI()),
  "none"
);

AttachBehavior:MemberRegister("maskNode",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI()),
  "none"
); 

AttachBehavior:MemberRegister("HeadOffset",
  venuscore.ScriptTypes.FloatArrayType(
      3,
      AttachBehavior.GetHeadOffset,
      AttachBehavior.SetHeadOffset
));

return AttachBehavior;