local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local nodeutility = require "apolloutility.nodeutility"
local apollonode = require "apolloutility.apollonode"
require "utility"
require "venusdebug"
local apolloDefine = require "apolloutility.defiend"




local debugske = {}

local parents = {0,1,2,0,4,5,0,7,8,0,10,11,0,13}


function debugske:Initialize()
  self.trans = {}
  self.renders = {}
  self.nodes = {}
  self.trans = {}
  self.lightnode = apollonode.LightNode(apolloengine.LightComponent.LT_DIRECTIONAL);
  
  self.lightnode:SetColor(
    mathfunction.vector3(1,1,1));
  
  self.lightnode:SetLocalDirection(
    mathfunction.vector3(0.2,-1,-0.3));
end

function debugske:Draw(pos3d)
  for i =1 , #parents do
    if parents[i] ~= 0 then

      local mypos = mathfunction.vector3((pos3d[i][1]+1.5)/4,(pos3d[i][2]+1)/4,pos3d[i][3]/4);
      local paridx = parents[i]
      local parentpos = mathfunction.vector3((pos3d[paridx][1]+1.5)/4,(pos3d[paridx][2]+1)/4,pos3d[paridx][3]/4);
      local cubepos = (mypos+parentpos)/2;
      local dir = parentpos-mypos;
      local length = dir:Length();
      local otherscale = length/4;
      dir:NormalizeSelf();
      local rotation = mathfunction.Quaternion();
      rotation:AxisToAxis(mathfunction.vector3(0,0,1),dir);
      
      if self.trans[i]==nil then
        local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
        local node = scene:CreateNode(apolloengine.Node.CT_NODE);
        --local node = apolloengine.Node();
        local cube = node:CreateComponent(apolloengine.Node.CT_RENDER); 
        local trans = node:CreateComponent( apolloengine.Node.CT_TRANSFORM); 
        cube:PushMetadata(
        apolloengine.RenderObjectMaterialMetadata(
          apolloengine.PathMetadata("comm:documents/material/lightingonly.material")));  
        cube:PushMetadata(
          apolloengine.RenderObjectMeshFileMetadate("comm:documents/model/cube.mesh"));  
        cube:CreateResource();
       
        
        table.insert(self.renders, cube);
        table.insert(self.nodes, node);
        self.trans[i] = trans;		
      end
      
      self.trans[i]:SetLocalScale(mathfunction.vector3(otherscale,otherscale,length));
      self.trans[i]:SetLocalPosition(cubepos);
      self.trans[i]:SetLocalRotation(rotation);
    end
  end
end

return debugske;