local triggerdefined = require "videodecet.defined"
local videodecet = require "videodecet"
local soundplayer = require "soundplayer"
local b3 = require 'behavior3.b3';
require 'behavior3.core.Condition'
require "utility"

local volumeaction = b3.Class("VolumeAction", b3.Condition)

function volumeaction:ctor(properties, target)
  b3.Condition.ctor(self)
	self.name = "VolumeAction"
  self.volume = properties.volume;
end

function volumeaction:tick(tick)
  local volume = soundplayer.GetVolume();
  if volume >= self.volume then
    return b3.SUCCESS;
  end
  return b3.FAILURE;
end

return volumeaction;