--local modelnodep = require "apolloutility.apollonode.toonmodel.charaModelNode"
local modelnodep = require "apolloutility.apollonode.modelnode"
local skeletonnode = require "apolloutility.apollonode.skeletonnode"
local trasnnode = require "apolloutility.apollonode.trasnnode"
local defiend = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venusjson = require "venusjson"
local Object = require "classic"
local modelnode = require "apolloutility.apollonode.toonmodel.meshnodetoon"
local cjson = require "cjson"
local toondefined = require "apolloutility.apollonode.toonmodel.toondefined"
local toonmat = require "apolloutility.apollonode.toonmodel.toonshader"

apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"INTERNAL_EYETOOBJDIR");
apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"INTERNAL_LightTOOBJDIR");
--模型节点
local charaModelToonNode = modelnodep:extend();

local TextureSlot = 
{
  TS_DIFFUSE = 0,
  TS_NORMAL = 1
};

local MaterialType = 
{
  MT_OPAQUE = 0,
  MT_TRANSPARENT = 1
};

function charaModelToonNode:new()
  
  charaModelToonNode.super.new(self);
end
function charaModelToonNode:SetMatUse(matuse)
  self.matuse = matuse;
end

function charaModelToonNode:CreateResource2(rootpath, defmaterial, memoryuseage)
  local res = true;
  memoryuseage = memoryuseage or apolloengine.VertexBufferEntity.MU_STATIC;
  local configFullPath = rootpath .. "/" .. "config.json";
  local modelconfig = venusjson.LaodJsonFile(configFullPath);
  if modelconfig.version ~=2 then
    return; 
  end
  self.version = 2;
  local bind = mathfunction.Aabbox3d();

  local hasAnim = false;
  local isHasScale = false;

  if modelconfig.skeleton~=nil then
    local skeletonPath = modelconfig.skeleton.name;
    skeletonPath = rootpath .. "/" .. skeletonPath;

    local animInfos =  modelconfig.skeleton.animation;
    animInfos.name = rootpath .. "/" .. animInfos.name;
   
    local skenode = skeletonnode();
    skenode:SetSkeletonAndAnims(skeletonPath,animInfos );
    self:AttachNode(skenode);
    self.skeletonNode = skenode;
    hasAnim = true;
    isHasScale = animInfos.hasscale;
  end

  local matuse =  self.matuse and  self.matuse or toondefined.matuse;

  for meshKey,meshValue in pairs(modelconfig.meshes) do
   -- if(toondefined.matuse[meshValue.name]~=nil and "./data/tail.mesh"==meshValue.name)
    if(matuse[meshValue.name]~=nil)
    then
      local meshpath = meshValue.name;
      local meshFullPath = rootpath .. "/" .. meshpath;
      local diffusetex;
      local normaltex;
      local pbrtex;
      local diffuseFullPath;
      local normalFullPath;
      local materialtype;
      local pbrtextureFullPath;
      local ispbr = false;
      local reflectiontex;
      local reflectionfullPath;
      
      local material = meshValue.material;
      if material then
        materialtype = material.alphamode;
        if material.normaltexture then
          normaltex = material.normaltexture.path;
        end
        
        if material.pbrmetallicroughness.basecolortexture then
          diffusetex = material.pbrmetallicroughness.basecolortexture.path;
        end

      if material.reflectiontexture then
            reflectiontex = material.reflectiontexture.path;
        end
      end
      
      if diffusetex then
        diffuseFullPath = rootpath .. "/" .. diffusetex;
      end
      if normaltex then
        normalFullPath = rootpath .. "/" .. normaltex;
      end
    if reflectiontex then
          reflectionfullPath = rootpath .. "/" .. reflectiontex; 
      end

      local materialFullPath = defmaterial or defiend.model_simple_material_path;
      if material.pbrmetallicroughness.metallicroughnesstexture ~= nil then  --pbr材质
        ispbr = true;
        materialFullPath = defiend.model_pbr_material_path;
        pbrtex = material.pbrmetallicroughness.metallicroughnesstexture.path;
        pbrtextureFullPath = rootpath .. "/" .. pbrtex;
      end

      
      --local maxBone = meshValue.maxbonecnt;
      local maxBone = nil;

      local transList = meshValue.translation;
      local rotList = meshValue.rotation;
      local scaleList = meshValue.scale;
      
      local bindmin = meshValue.boundingbox.min;
      local bindmax = meshValue.boundingbox.max;
      
      local bindboxV = mathfunction.Aabbox3d(
        mathfunction.vector3(bindmin[1],bindmin[2],bindmin[3]),
        mathfunction.vector3(bindmax[1],bindmax[2],bindmax[3]));
      
      if hasAnim and maxBone~=nil then
        local suffix = materialtype == MaterialType.MT_TRANSPARENT and "_t" or "";
        local materialpath = 
          ispbr
            and (isHasScale and defiend.model_pbr_matrix_material_path or defiend.model_pbr_dual_material_path)
            or (isHasScale and defiend.model_matrix_material_path or defiend.model_dual_material_path)
        materialFullPath = string.format(materialpath, maxBone,suffix);
      
        self.isSkined = true;
      end

      local modelnode = modelnode();
      modelnode:SetSequence(self.sequence);
      if self.keepsource then
        modelnode:SetKeepSource(self.keepsource);
      end
      
      if diffuseFullPath then 
        modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,diffuseFullPath);
      end 
    
      if normalFullPath then
        modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_BUMP,normalFullPath);
      end

    if reflectionfullPath then 
       materialFullPath = defiend.model_reflection_path;
        modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_REFLECTION,reflectionfullPath,apolloengine.TextureEntity.TW_MIRRORED_REPEAT);
      end
      
      if material.pbrmetallicroughness.metallicroughnesstexture ~= nil then  --pbr材质
        modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_AMR,pbrtextureFullPath);
        modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_NORMAL,normalFullPath);
        modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_ALDEBO,diffuseFullPath);
      end
    
      self.nodes[meshpath] = modelnode;
      --if(materialFullPath=="comm:documents/material/nl_skeleton4bmatrix.material")
      --then
       -- materialFullPath = self:GetMaterialPath();
     -- end
      --local tm = toonmat();
      --tm:Parse(toondefined.chara_hair);
      --local res = tm:GetMatSrc();
      --LOG(res)
      --materialFullPath = self:GetMaterialPath(materialFullPath);
      --local test = self:GetMaterialString();
      modelnode:SetMaterialSrcType(toondefined.matsrcType.String);
      --modelnode:SetToonShader("hair");
      modelnode:SetToonShader(matuse[meshValue.name]);
      res = res and modelnode:CreateResource(meshFullPath,res,nil,nil,nil, nil, memoryuseage);
      --modelnode:SetLocalPosition(transV);
      --modelnode:SetLocalRotation(rotationV);
      --modelnode:SetLocalScale(scaleV);
      modelnode:SetBindBox(bindboxV);
      bind:Contains(bindboxV);
      if(maxBone~=nil) then
        local skinCom = modelnode:CreateComponent(apolloengine.Node.CT_SKIN);

        skinCom:SetHasScale(isHasScale);
        skinCom:SetSkeletonComponent(self.skeletonNode.skeleton);
        table.insert(self.skincoms,skinCom);
      end
      self:AttachNode(modelnode);
    end
  end
  self.bindbox:SetBindBox(bind);
  return res;
end

function charaModelToonNode:CreateTex(strpath)
    local tex = apolloengine.TextureEntity();
    tex:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_BORDER,
      apolloengine.TextureEntity.TW_CLAMP_TO_BORDER,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      strpath));
    local res = tex:CreateResource();
    return res and tex or nil;
end

function charaModelToonNode:SetParameter(slot, val)
  for key,value in pairs(self.nodes) do
    value:SetParameter(slot, val);
  end
end

function charaModelToonNode:CreateResource(rootpath, defmaterial, memoryuseage)
  charaModelToonNode.super.CreateResource(self,rootpath, defmaterial, memoryuseage);
end

return charaModelToonNode;