
#DEFPARAMS
UNIFORM_LEFT_EYE = {"UNIFORM_LEFT_EYE", VEC2, "1.0,1.0"},
UNIFORM_RIGHT_EYE = {"UNIFORM_RIGHT_EYE", VEC2, "1.0,1.0"},
UNIFORM_RADIUS = {"UNIFORM_RADIUS", VEC2, "1.0,1.0"},
UNIFORM_RATIOASPECT = {"UNIFORM_RATIOASPECT", FLOAT, "1.0"},
UNIFORM_FACECOEF = {"UNIFORM_FACECOEF", FLOAT, "1.0"},
UNIFORM_SCALERATIO = {"UNIFORM_SCALERATIO", FLOAT, "1.0"},
UNIFORM_NOSECOEF = {"UNIFORM_NOSECOEF", FLOAT, "1.0"},
UNIFORM_MOUTHCOEF = {"UNIFORM_MOUTHCOEF", FLOAT, "1.0"},

#END

#DEFTAG
ShaderName = "biggereyes"
RenderQueue = "Overlay"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 in_Position : POSITION;
	float2 in_Coordinate : TEXCOORD0;
};

struct v2f
{
	float2 out_Coordinate : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

float2 UNIFORM_LEFT_EYE;
float2 UNIFORM_RIGHT_EYE;
float2 UNIFORM_RADIUS;
float UNIFORM_RATIOASPECT;
float4 UNIFORM_FACE_PTS[37];
float UNIFORM_FACECOEF;
float2 FACEPARA[19];
float UNIFORM_SCALERATIO;
float3x3 UNIFORM_ZOOMSCALE;

float UNIFORM_NOSECOEF;
float UNIFORM_MOUTHCOEF;
float2 NOSEPARAMS[4];
float4 NOSEPOINTS[4];
float2 MOUTHPARAMS[2];
float2 MOUTHPOINTS[4];

float2 transformWarpPositionToUseByFactor(float2 currentPoint, float2 src, float2 dst, float radiusFactor, float deltaFactor, float aspectRatio)
{
    float2 currentPointToUse = float2(currentPoint.x, currentPoint.y * aspectRatio);
    float2 srcToUse = float2(src.x, src.y * aspectRatio);

    float2  rvec = currentPointToUse - srcToUse;
    float rdot = dot(rvec, rvec);

    float2  dir    = dst - src;
    float dirDot = dot(dir, dir);
    float radiusSquare = radiusFactor * radiusFactor * dirDot; 

    if(rdot > radiusSquare)
    {
        return currentPoint;
    }

    float r = sqrt(rdot);

    float dirLen = sqrt(dirDot);
    dir = dir / dirLen;

    float dist  = radiusSquare - rdot;
    float delta = deltaFactor * dirLen;
    float tmp = r - delta;
    float alpha = dist / (dist + tmp * tmp);
    alpha = alpha * alpha;
    float2 positionToUse = currentPoint - (alpha * delta) * dir;
     
    return positionToUse;
} 

//imgrated from facelift_<product>.shader for nose
float2 transformWarpPositionToUseByFactorV2(float2 currentPoint, float2 src, float2 dst, float2 face_dir, float radiusFactor, float deltaFactorX, float deltaFactorY, float aspectRatio)
{
    float deltaFactor = sqrt(deltaFactorX * deltaFactorX + deltaFactorY * deltaFactorY * aspectRatio * aspectRatio);
    float2 currentPointToUse = float2(currentPoint.x, currentPoint.y * aspectRatio);
    float2 srcToUse = float2(src.x, src.y * aspectRatio);
    float2 dstToUse = float2(dst.x, dst.y * aspectRatio);

    float2  rvec = currentPointToUse - srcToUse;
    float rdot = dot(rvec, rvec);

	float aspectRatio_ref = 1.765;
    float2  dir    = dstToUse - srcToUse; dir.y = dir.y / aspectRatio_ref;
    float dirDot = dot(dir, dir);
    float radiusSquare = radiusFactor * radiusFactor * dirDot;

    if(rdot > radiusSquare)
    {
        return currentPoint;
    }

    float r = sqrt(rdot);

    float dirLen = sqrt(dirDot);
    dir = dir / dirLen;

    float dist  = radiusSquare - rdot;
    float delta = deltaFactor * dirLen;
    float tmp = r - delta;
    float alpha = dist / (dist + tmp * tmp);
    alpha = alpha * alpha;

	float2 dir_face_x = dot(dir, face_dir) * face_dir;
	float2 dir_face_y = dir - dir_face_x;
	float2 displace_x =  - (alpha * delta / (deltaFactor + 0.0001) * deltaFactorX) * dir_face_x;
	float2 displace_y =  - (alpha * delta / (deltaFactor + 0.0001) * deltaFactorY) * dir_face_y;
	float2 positionToUse;
	positionToUse.x = currentPointToUse.x + displace_x.x + displace_y.x;
	positionToUse.y = currentPoint.y + (displace_x.y + displace_y.y) / aspectRatio * aspectRatio_ref;
    return positionToUse;
}

float2 scaleWarpPositionToUse(float2 centerPostion, float2 currentPosition, float radius, float scaleRatio, float aspectRatio)
{
     
    float2 currentPositionToUse = float2(currentPosition.x, currentPosition.y * aspectRatio);
    float2 centerPostionToUse = float2(centerPostion.x, centerPostion.y * aspectRatio);

    float2  rvec = currentPositionToUse - centerPostionToUse;
    float rdot = dot(rvec, rvec);
    
    float radius_square = radius * radius;
    if(rdot > radius_square)
    {
        return currentPosition;
    }

    float r = sqrt(rdot);
    float factor = r / radius - 1.0;   
    float alpha = 1.0 - scaleRatio * factor * factor;
    float2 positionToUse = centerPostion + alpha * (currentPosition - centerPostion);
     
    return positionToUse; 
}


//imgrated from facelift_<product>.shader for mouth
// R the max radius, r the reference inner radius, ellipse_alpha is a/b for ellipse, face_dir_x is the direction vector for x of face
float2 warpObliqueEllipseScalePositionToUse(float2 center, float2 p, float2 face_dir_x, float r, float R, float inten, float ratio, float ellipse_alpha)
{
    // cos(agnle) = face_dir.x; sin(angle) = - face_dir.y;
    float2 face_dir_y = float2(-face_dir_x.y, face_dir_x.x);
    float2 m_point = p;
    float2 p_u = float2(p.x, p.y * ratio + 0.5 - 0.5 * ratio * ellipse_alpha);
    float2 c_u = float2(center.x, center.y * ratio + 0.5 - 0.5 * ratio * ellipse_alpha);
    float2 vec_pc = p_u - c_u;
    float2  p_r = float2(dot(vec_pc, face_dir_x), dot(vec_pc, face_dir_y));

    float d = sqrt(p_r.x * p_r.x + p_r.y * p_r.y * ellipse_alpha * ellipse_alpha);
    float scale = (R - r) / r * inten;
    float r_m = r * (1.0 + scale);
    if (d < r_m)
    {
        float alpha = 1.0 / (1.0 + scale);
        m_point = center + (p - center) * alpha;
    }
    else if (d < R)
    {
        float percent = (R - d) / (R - r_m);
        m_point = center + (p - center) * (R - percent * (R - r)) / d;
    }
	return m_point;
}

v2f vert(appdata v)
{
#define facePointsArray UNIFORM_FACE_PTS
#define facepara  FACEPARA
#define nosepoints NOSEPOINTS
#define noseparam NOSEPARAMS
#define mouthpoints MOUTHPOINTS
#define mouthparam MOUTHPARAMS


	float4 in_Position = v.in_Position;
	float2 in_TexCooridate = v.in_Coordinate;
	float2 leftEyeCenterPosition = UNIFORM_LEFT_EYE;
	float2 rightEyeCenterPosition = UNIFORM_RIGHT_EYE;
	float2 radius = UNIFORM_RADIUS;
	float aspectRatio = UNIFORM_RATIOASPECT;
	float faceCoef = UNIFORM_FACECOEF;
    float noseCoef = UNIFORM_NOSECOEF;
    float mouthCoef = UNIFORM_MOUTHCOEF;
	float scaleRatio = UNIFORM_SCALERATIO;
	float3x3 zoomscale = UNIFORM_ZOOMSCALE;

    float2 newpos = (mul(float3(in_Position.xy,1.0), transpose(zoomscale))).xy;
    float4 outPos = float4(newpos,in_Position.z,in_Position.a);
    
    float2 newTexCooridate = float2((newpos.x+1.0)*0.5,(newpos.y+1.0)*0.5);
    const int facePointNum = 37;
    float2 positionToUse  = newTexCooridate * 2.0 - 1.0;

    float2 face_dir = rightEyeCenterPosition - leftEyeCenterPosition;
    face_dir = float2(face_dir.x, face_dir.y * aspectRatio);
    face_dir = face_dir / sqrt(dot(face_dir, face_dir));
    
    const float threshold = 0.001;
    float2 displacement = float2(0, 0);
    float2 new_position_single;

    //眼睛
    positionToUse = scaleWarpPositionToUse(leftEyeCenterPosition,  positionToUse, radius.x, 0.7*scaleRatio, aspectRatio);
    positionToUse = scaleWarpPositionToUse(rightEyeCenterPosition, positionToUse, radius.y, 0.7*scaleRatio, aspectRatio);
    
    for(int j = 0; j < facePointNum; ++j){
      int k = j/2;
      positionToUse = transformWarpPositionToUseByFactor(positionToUse, facePointsArray[j].xy, facePointsArray[j].zw, facepara[k].x, facepara[k].y* faceCoef, aspectRatio);
    }

    //鼻子
    // noseparam[0].x: moving param, noseparam[0].y: moving radius
    if(noseCoef > threshold)
    {
      for(int j = 0 ; j < 4 ; j ++)
      {
        new_position_single = transformWarpPositionToUseByFactorV2(positionToUse, nosepoints[j].xy, nosepoints[j].zw, face_dir, noseparam[j].y, noseparam[j].x * noseCoef, 0, aspectRatio);
        displacement = displacement + new_position_single - positionToUse;
      }
    }
  
    //// 嘴
    //// mouthpoints: top, down, left, right
    //// mouthparam: x radius, y radius, x scale, y scale
    if(abs(mouthCoef) > threshold)
    {
      float2 px = mouthpoints[3] - mouthpoints[2];
      float2 py = mouthpoints[0] - mouthpoints[1];
      float ellipse_alpha = sqrt(sqrt(dot(px, px)) / sqrt(dot(py, py)) * mouthparam[1].y);
      float R = sqrt(dot(px, px)) * mouthparam[0].x;
      float r = sqrt(dot(px, px)) * mouthparam[0].y;
      float inten = mouthparam[1].x * mouthCoef;
      //float Ru = (R - r) / inten * r + r;
  
      float2 mouth_center = (mouthpoints[0] + mouthpoints[1] + mouthpoints[2] + mouthpoints[3]) / 4;
      new_position_single = warpObliqueEllipseScalePositionToUse(mouth_center, positionToUse, face_dir, r, R, inten, aspectRatio, ellipse_alpha);
      displacement = displacement + new_position_single - positionToUse;
    }

    positionToUse = positionToUse + displacement;
    float2 out_TexCooridate =  0.5 * positionToUse + 0.5;

	v2f o;
	o.vertex = UniformNDC(outPos);
	o.out_Coordinate = float2(out_TexCooridate.x, 1.0 - out_TexCooridate.y);
	return o;
}

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	#define inputImageTexture TEXTURE_DIFFUSE
	float2 textureCoordinate = i.out_Coordinate.xy;

	mainColor = inputImageTexture.Sample(TEXTURE_DIFFUSE_Sampler,float2(clamp(textureCoordinate.x,0.001,0.999),clamp(textureCoordinate.y,0.001,0.999)));
}

ENDCG
#END
