
local facecute = require "facecute"
--local facegame = require "game.facegame"
local venusjson = require "venusjson"
local videodecet = require "videodecet"
local posture = require "facecute.estimates.transposture";
local mathfunction = require "mathfunction"
local headtargetgame = require "game.headtargetgame"
local immortalgame   = require "game.immortalgame"
--入口文件，解析配置表，调用和组装变形、3d、2d等功能
local facecutegame = {}

local maxhead = 3;
function facecutegame:Exit()
  
  for i=1,maxhead do
  self.headtargets[i]:ReleaseResource();
  end
  self.immortal:ReleaseResource();
  self.headtargets = nil;
  self.immortal = nil;
end

function facecutegame:LoadConfigGame(path,gameId)
  
  self.maincamera = self.maincamera and self.maincamera or facecute.maincamera;
  if(not self.headtargets)
  then
    self.headtargets =  {};
    for i=1, maxhead do
      local ht = headtargetgame(self.maincamera);
      ht.headIndex = i;
      table.insert(self.headtargets, ht);
    end
  end

  if(not self.immortal)
  then
      self.immortal = immortalgame(self.maincamera);
  end
  
  
  
  local res = true;
  local pathDir= string.match(path, "(.+)/[^/]*%.%w+$");
  local rootconfig = venusjson.LaodJsonFile(path);
  facecute:_ProcesssActions(rootconfig);
  local rootconfig, fbconfig = facecute:_SplitConfig(rootconfig);
  local paramters = {pathDir,tonumber(rootconfig["version"])};
  paramters["gameId"] = gameId;
 -- local headtargets = facegame:FilterHeadTargets(self.headtargets);
  --for _, ht in ipairs(self.headtargets) do
   -- res = res and ht:ParseConfig(rootconfig, paramters);
  --end
  if rootconfig.deformationFileName then
    local defpath = pathDir..'/'..rootconfig.deformationFileName;
    local deformationconfig = venusjson.LaodJsonFile(defpath);
    --for _, ht in ipairs(self.headtargets) do
    for _, ht in ipairs(headtargets) do
      res = res and ht:ParseConfig(deformationconfig, paramters);
    end
  end  
  
  res = res and self.immortal:ParseConfig(fbconfig, paramters);
  self.immortal:SetShow(true);
  
  if(rootconfig.parts3d and rootconfig.parts3d.metaScenePath)
  then
    local filename = string.match(path, ".+/([^/]*%.%w+)$");
    filename = facecute:stripextension(filename);
    local metascenepath = pathDir..'/'..rootconfig.parts3d.metaScenePath..'/'..filename..".metascene";
    local metasceneconfig = venusjson.LaodJsonFile(metascenepath);
    paramters["metascene"] = metasceneconfig;
  end
  
  --for _, ht in ipairs(self.headtargets) do
   for _, ht in ipairs(self.headtargets) do
    res = res and ht:ParseConfig(rootconfig, paramters);
  end
  
  if rootconfig.soundParts then
  end
  return res;
end

local emptyaction = {}
local defpos = mathfunction.vector3(0,0,-0.5);
local defrot = mathfunction.Quaternion();
local definfpos = mathfunction.vector3(-100000000,-100000000,-100000000);
function facecutegame:Update(timespan,maincamera)
  local faces = videodecet:GetFaces();
  local actions = videodecet:GetActions();--返回当前识别出来的动作
  
  --faces,actions = facegame:FilterFaces(faces,actions);
  
  if faces then
    posture:Update(faces,maincamera);
    local postures = posture:GetPostures();
    local actioncount = facecute:_ActiveActionCount(actions);
    local showcount = math.max(#postures, actioncount);
    
    --先隐藏不要的
    for i = showcount + 1, #self.headtargets do
      local hn = self.headtargets[i]
      hn:SetShow(false);
    end
    
    --再修改需要的
    if 0 == #postures then
      --如果没有人头我们就默认更新
      local nilface = facecute:GetNilFaceInfo();
      facecute.immortal:Update(timespan, nilface, nil,nil, actions[1] or emptyaction);
      --facegame:UpdateFace(timespan, nilface, definfpos, defrot, actions[1] or emptyaction);
      for i=1, showcount do
        local hn = self.headtargets[i];
        if hn then
          hn:SetShow(true);
          --hn:Update(timespan, nilface, defpos, defrot, actions[i]);
           hn:Update(timespan, nilface, definfpos, defrot, actions[i]);
        end        
      end
    else
      for index, est in ipairs(postures) do
        if 1 == index then
          --如果有人头我们就按照第一个人的数据更新
          self.immortal:Update(timespan, faces[index], est.position, est.rotation, actions[index]);
          --facegame:UpdateFace(timespan, faces[index], est.position, est.rotation, actions[index]);
        end 
        local hn = self.headtargets[index];
        if hn then
          hn:SetShow(true);
          hn:Update(timespan, faces[index], est.position, est.rotation, actions[index]);
        end      
      end
    end  
  end
end

return facecutegame;