local object = require "venuscore.rtti.object"


local BaseType = object:extend("BaseType");

function BaseType:new(get, set)
  self.keyname = nil;
  self.get = get;
  self.set = set;
end

function BaseType:SetKeyname(keyname)
  self.keyname = keyname;
  if not self.get then
    self.get = function(currentobj)
      return currentobj[keyname];
    end    
  end  
  if not self.set then
    self.set = function(currentobj, value)
      currentobj[keyname] = value;
    end    
  end  
end

function BaseType:GetValue(obj)
  return self.get(obj)
end

function BaseType:SetValue(obj, value)
  self.set(obj, value)
end

function BaseType:isMemberTypeReference()
  return false;
end

return BaseType;