local libvenuscore = require "libvenuscore"

local rttimanager = libvenuscore.RttiManager;
rttimanager.classes = {}

local _fNativeNewinstance = libvenuscore.RttiManager.Newinstance;
assert(_fNativeNewinstance);


function rttimanager:RegisterClass(name, cla)
  if not self.classes[name]
    and not libvenuscore.RttiManager:haveClass(name) then 
    self.classes[name] = cla;
  else
    error(string.format("calss %s is duplicate", name));
  end
end

function rttimanager:Newinstance(name, host)
  if name then
    if self.classes[name] then
      local cla = self.classes[name];
      return cla(host);
    else
      local cla = _fNativeNewinstance(libvenuscore.RttiManager, name, host);
      return cla;
    end
  end
  error("name is nil or class not found");
end

return rttimanager;