local types = require "venuscore.rtti.types"
local Object = require "venuscore.rtti.object"
local mathfunction = require "mathfunction"
local libvenuscore = require "libvenuscore"


--防止loop，拆分实现
function Object:MemberRegister(name, typeinfo, tag)
  --注册的成员变量名称不能重复
  --使用数组，遍历的时候更高效，所以需要注册的时候检查重复
  for _, value in ipairs(self.__members) do
    assert(value ~= name);
  end
  table.insert(self.__members, name);
  typeinfo = typeinfo or types.BaseType();
  typeinfo:SetKeyname(name);
  typeinfo.tag = tag;
  self.__typeinfos[name] = typeinfo;
end

--下列三个函数提供给c++调用，做数据传递
function Object:_GetScriptValue(propertyname, key)
  local p = self.propertys[propertyname]
  return p.get(key);
end

function Object:_SetScriptValue(propertyname, key, value)
  local p = self.propertys[propertyname]
  p.set(key, value);
end

function Object:_GetScriptProperty()
  self.propertys = {};
  for _, name in ipairs(self.__members) do
    local info = self.__typeinfos[name];
    if info:is(types.FloatArrayType) then
      local dim = info:GetDimension();
      local propertyinfo = {}
      propertyinfo.Key = name;
      propertyinfo.Subkey = "";
      propertyinfo.Type = libvenuscore.NativeType.DT_FLOAT_ARRAY;
      propertyinfo.get = function(key)
        return info:GetValue(self);
      end
      propertyinfo.set = function(key, value)
        local newtable = {};
        for i=1, #value, dim do
          local data = {}
          for j=1, dim do
            table.insert(data, value[i+j-1])
          end
          table.insert(newtable, data);
        end
        info:SetValue(self, newtable);
      end
      self.propertys[name] = propertyinfo;
    elseif info:is(types.BaseType) then
      local value = self[name];
      local vt = type(value);
      if "number" == vt then
        local propertyinfo = {}
        propertyinfo.Key = name;
        propertyinfo.Subkey = "";
        propertyinfo.Type = libvenuscore.NativeType.DT_FLOAT;
        propertyinfo.get = function(key)
          return info:GetValue(self);
        end
        propertyinfo.set = function(key, value)
          info:SetValue(self, value);
        end
        self.propertys[name] = propertyinfo;
      elseif "boolean" == vt then
        local propertyinfo = {}
        propertyinfo.Key = name;
        propertyinfo.Subkey = "";
        propertyinfo.Type = libvenuscore.NativeType.DT_BOOL;
        propertyinfo.get = function(key)
          return info:GetValue(self);
        end
        propertyinfo.set = function(key, value)
          info:SetValue(self, value);
        end
        self.propertys[name] = propertyinfo;
      elseif "userdata" == vt then
        if value:isType(mathfunction.vector1:RTTI())
          or value:isType(mathfunction.vector2:RTTI())
          or value:isType(mathfunction.vector3:RTTI())
          or value:isType(mathfunction.vector4:RTTI()) then
            local subkeys = {"x", "y", "z", "w"};
            local count = value:VolumeCount();
            for i=1, count do
              local propertyinfo = {}
              propertyinfo.Key = name;
              propertyinfo.Subkey = subkeys[i];
              propertyinfo.Type = libvenuscore.NativeType.DT_FLOAT;
              propertyinfo.get = function()
                return value:GetVolume(i);
              end              
              propertyinfo.set = function(key, v)
                value:SetVolume(i, v);--直接设置原始的闭包数值可能存在一定的问题
                info:SetValue(self, value);
              end
              self.propertys[name..subkeys[i]] = propertyinfo;
            end
        end
      end
    end
  end  
  return self.propertys;
end