local rttimanager = require "venuscore.rtti.rttimanager"
local venuscore = require "libvenuscore"



local Object = {}
Object.__index = Object
Object.__members = {}
Object.__typeinfos = {}


function Object:new()
end


function Object:extend(name)
  local cls = {}
  for k, v in pairs(self) do
    if k:find("__") == 1 then
      cls[k] = v
    end
  end
  cls.__index = cls
  cls.super = self
  cls.__members = {}--初始化导出成员变量表
  cls.__typeinfos = {}
  for _, v in ipairs(self.__members) do 
      table.insert(cls.__members, v)
  end
  for k, v in ipairs(self.__typeinfos) do 
      cls.__typeinfos[k] = v;
  end
  setmetatable(cls, self)
  if name then
    cls.__name = name;
    cls.__typeid = venuscore.Utility:HashCode(name)
    rttimanager:RegisterClass(name, cls);
  end  
  return cls
end


function Object:implement(...)
  for _, cls in pairs({...}) do
    for k, v in pairs(cls) do
      if self[k] == nil and type(v) == "function" then
        self[k] = v
      end
    end
  end
end


function Object:is(T)
  local mt = getmetatable(self)
  while mt do
    if mt == T then
      return true
    end
    mt = getmetatable(mt)
  end
  return false
end

function Object:GetObjectID()
  local temp = getmetatable(self)
  setmetatable(self, nil)
  local ret = tostring(self)
  setmetatable(self, temp)
  return ret;
end


function Object:__tostring()
  return "Object"
end


function Object:__call(...)
  local obj = setmetatable({}, self)
  obj:new(...)
  return obj
end

function Object:cast(obj)
  setmetatable(obj, self)
  obj.__index = Object
  return obj
end

function Object:GetMetatable()
  return getmetatable(self);
end

function Object:clone()
  local obj = table.deepcopy(self);
  setmetatable(obj, self)
  obj.__index = Object
  return obj
end

--对齐c++接口
function Object:GetTypeName()
  return self.__name;
end

function Object:GetTypeID()
  return self.__typeid;
end

function Object:GetTypeInfomation(name)
  return self.__typeinfos[name];
end

function Object:isMemberTypeReference(name)
  local info = self.__typeinfos[name];
  return info and info:isMemberTypeReference() or false;
end

function Object:GetScriptValue(key)
  local info = self:GetTypeInfomation(key);
  return info:GetValue(self);
end

function Object:SetScriptValue(key, value)
  local info = self:GetTypeInfomation(key);
  return info:SetValue(self, value);
end



return Object
