local libvenuscore = require "libvenuscore"
local object = require "venuscore.rtti.object"


local ActorNode = libvenuscore.Object:extend("ActorNode");

function ActorNode:new(name)
  self.node = libvenuscore.Actor();
  self.node._Script = self;
  self:SetName(name or "Actor");
end

function ActorNode:GetNativeNode()
  return self.node;
end

function ActorNode:SetNativeNode(node)
  self.node = node;
end

function ActorNode:SetName(name)
  self.node:SetName(name);
end

function ActorNode:GetName()
  return self.node:GetName();
end


function ActorNode:AttachNode(node)
  if type(node) ~= "userdata" then
    self.node:AttachNode(node.node);
  end
  
end

function ActorNode:DetachNode(node)
  self.node:DetachNode(node.node);
end

return ActorNode;