
local MemberIterator = require "venuscore.rtti.mpairs"
local RttiManager = require "venuscore.rtti.rttimanager"
local Serializer = require "venuscore.bundle.fserializer.fserializer"
local FDatatype = require "venuscore.bundle.fserializer.fdatatype"

local apollocore = require "apollocore"
local venuscore = require "libvenuscore"
local bit = require("bit")


local BundleSystem = {}

BundleSystem.Version = 1; --版本号

BundleSystem.SerializeDelegates = {};
BundleSystem.DeserializeDelegates = {}
BundleSystem.DeserializeInitDelegates = {};
BundleSystem.SerializeStartedDelegates = {}; --序列化开始的回调
BundleSystem.SerializeFinishedDelegates = {}; --序列化完成的回调
BundleSystem.DeserializeFinishedDelegates = {}; --反序列化完成的回调


function BundleSystem:OnSerialize(fieldname, func)
  assert(not BundleSystem.SerializeDelegates[fieldname]);
  BundleSystem.SerializeDelegates[fieldname] = func;
end

function BundleSystem:OnDeserialize(typename, func)
  assert(not BundleSystem.DeserializeDelegates[typename]);
  BundleSystem.DeserializeDelegates[typename] = func;
end

function BundleSystem:OnDeserializeInit(typename, func)
  assert(not BundleSystem.DeserializeInitDelegates[typename]);
  BundleSystem.DeserializeInitDelegates[typename] = func;
end

function BundleSystem:OnSerializeStarted(typename, func)
  assert(not BundleSystem.SerializeStartedDelegates[typename]);
  BundleSystem.SerializeStartedDelegates[typename] = func;
end

function BundleSystem:OnSerializeFinished(typename, func)
  assert(not BundleSystem.SerializeFinishedDelegates[typename]);
  BundleSystem.SerializeFinishedDelegates[typename] = func;
end

function BundleSystem:OnDeserializeFinished(typename, func)
  assert(not BundleSystem.DeserializeFinishedDelegates[typename]);
  BundleSystem.DeserializeFinishedDelegates[typename] = func;
end


--测试打印table
function BundleSystem:ToStr(t,dometatables)
 local function basicToStr (o)
  if type(o) == "number" or type(o)=="boolean" then
   return tostring(o)
  elseif type(o) == "string" then
   return string.format("%q", o)
  else
   return tostring(o) --"nil"
  end
 end
 local strTG = {}
 --local basicToStr= basicSerialize --tostring
 if type(t) ~="table" then  return basicToStr(t) end
 local recG = 0
 local nameG="SELF"..recG
 local ancest ={}
 local function _ToStr(t,strT,rec,name)
  if ancest[t] then
   strT[#strT + 1]=ancest[t]
   return
  end
  rec = rec + 1
  ancest[t]=name
  strT[#strT + 1]='{'
  local count=0
  -------------
  --if t.name then strT[#strT + 1]=string.rep("\t",rec).."name:"..tostring(t.name) end
  ----------------
  for k,v in pairs(t) do
   count=count+1
   strT[#strT + 1]="\n"
   local kstr
   if type(k) == "table" then
    local name2=string.format("%s.KEY%d",name,count)
    strT[#strT + 1]=string.rep("\t",rec).."["
    local strTK = {}
    _ToStr(k,strTK,rec,name2)
    kstr=table.concat(strTK)
    strT[#strT + 1]=kstr.."]="
   else
    kstr = basicToStr(k)
    strT[#strT + 1]=string.rep("\t",rec).."["..kstr.."]="
   end
   
   if type(v) == "table" then
     local name2=string.format("%s[%s]",name,kstr)
     _ToStr(v,strT,rec,name2)
   else
    strT[#strT + 1]=basicToStr(v)
   end
  end
  if dometatables then
   local mt = getmetatable(t)
   if mt then
    local namemt = string.format("%s.METATABLE",name)
    local strMT = {}
    _ToStr(mt,strMT,rec,namemt)
    local metastr=table.concat(strMT)
    strT[#strT + 1] = "\n"..string.rep("\t",rec).."[METATABLE]="..metastr
   end
  end
  strT[#strT + 1]='}'
  rec = rec - 1
  return
 end
 _ToStr(t,strTG,recG,nameG)
 return table.concat(strTG)
end
function BundleSystem:prtable(...)
 for i=1, select('#', ...) do
  local t = select(i, ...)
  print(self:ToStr(t))
  print("\n")
 end
end


--从一个脚本node开始序列化
function BundleSystem:Serialize(rootnode)
  local apollonode = rootnode;
  if rootnode._Script then
    apollonode = rootnode._Script:GetNativeNode();
  end
  
  --开始序列化的通知
  self:SerializeStarted(rootnode);
  

  local serializeInfo = self:_SerializeTraverse(apollonode);

  --self:prtable(serializeInfo);

  --flatbuffer 序列化
  local serializer = Serializer();
  local encoder = serializer:GetEncoder();

  --整个场景应该只有一个根节点
  local cls = serializeInfo[1];
  if cls then
    --序列化版本号
    encoder:SetFieldInt("version",BundleSystem.Version);
    local childEncoder = encoder:GetChild();
    self:_SerializeCls(cls,childEncoder);
    encoder:SetFieldClass("Data",childEncoder);
  end
  
  --完成序列化的通知
  self:SerializeFinished(rootnode);

  return serializer:GetBuffer();  --返回序列化结果
end

function BundleSystem:DeSerialize(bufferAsString)
  local nodes = {};
  local referenceinfo = {}
  referenceinfo.nodemap = {}
  referenceinfo.callbacks = {}

  local serializer = Serializer();
  local decoder = serializer:GetDecoderFromBuffer(bufferAsString);
  
  --判断是不是从C++根节点开始序列化的，如果是排除此节点
  --C++内置的根节点不做反序列化
  local typename = decoder:AsString(1);
  if typename == "Actor" then
    local memberListCnt = decoder:GetLength();
    for i = 2, memberListCnt do
      local fieldName = decoder:GetFieldName(i);
      if string.find(fieldName,'ChildNodes') then
        local childDecoder = decoder:AsClass(i);
        self:_DeSerializeCls(childDecoder,nil,nodes, nil, referenceinfo);
      elseif fieldName == "Name" then
        local rootname = decoder:AsString(i);
        local apolloRootNode = venuscore.IApplication:GetRootNode();
        apolloRootNode:SetName(rootname);
      end
    end
  else
    self:_DeSerializeCls(decoder,nil,nodes, nil, referenceinfo);
  end

  for i = 1, #nodes do
    nodes[i]:OnDeserializeFinished();
  end

  for i, v in ipairs(referenceinfo.callbacks) do
    local obj = referenceinfo.nodemap[v.key];
    if obj then
      v.func(obj);
    else
      ERROR("unkown reference object id: "..v.key);
    end   
  end

  return nodes;
end

function BundleSystem:SerializeStarted(apolloNode)
  if apolloNode then
    if apolloNode._Script then
      apolloNode._Script:OnSerializeStarted();
    end
    local childList = apolloNode:GetChildrens();
    local childListCnt = #childList;
    for i = 1, childListCnt do
      local childNode = childList[i];
      self:SerializeStarted(childNode);
    end
  end
end

function BundleSystem:SerializeFinished(apolloNode)
  if apolloNode then
    if apolloNode._Script then
      apolloNode._Script:OnSerializeFinished();
    end
    local childList = apolloNode:GetChildrens();
    local childListCnt = #childList;
    for i = 1, childListCnt do
      local childNode = childList[i];
      self:SerializeFinished(childNode);
    end
  end
end


function BundleSystem:_SerializeCls(cls,encoder)
  local fieldName = cls["fieldname"];  
  local typename = cls["typename"];
  local members = cls["members"];
  local value = cls["value"];
  local __reference_uuid = cls["__reference_uuid"];
  encoder:SetFieldString("typename",typename);  --类型
  if __reference_uuid then
    encoder:SetFieldString("__reference_uuid",__reference_uuid);
  end  
  local memberCnt = #members;
  for i = 1, memberCnt do
    local member = members[i];
    local memberFieldName = member["fieldname"];
    local memberTypeName = member["typename"];
    local memberValue = member["value"];
    local childMembers = member["members"];    
    if memberTypeName ~= "number"
      and memberTypeName ~= "boolean"
      and memberTypeName ~= "string"
      and memberTypeName ~= venuscore.ScriptTypes.ReferenceTypeName then  --class 类型
      local childEncoder = encoder:GetChild();
      local childFieldName = self:_SerializeCls(member,childEncoder);  --class field 给一个key name
      encoder:SetFieldClass(childFieldName,childEncoder);
    else
      if memberTypeName == "number" then
        encoder:SetFieldFloat(memberFieldName,memberValue);
      elseif memberTypeName == "boolean" then
        encoder:SetFieldBool(memberFieldName,memberValue);
      elseif memberTypeName == "string" then
        encoder:SetFieldString(memberFieldName,memberValue);
      elseif memberTypeName == venuscore.ScriptTypes.ReferenceTypeName then
        encoder:SetFieldReference(memberFieldName,memberValue);
      end
    end
  end
  return fieldName;
end


--遍历C++场景，构建序列化信息
function BundleSystem:_SerializeTraverse(apollonode)
  local info = {}
  if apollonode then
    if apollonode._Script then
      self:_SerializeTraverseNode(apollonode._Script,nil,nil,info);  --从脚本序列化
    else
      self:_SerializeTraverseNode(apollonode,nil,nil,info); --序列化无脚本的C++node
    end
    local childList = apollonode.ChildNodes;
    local cls = info[1];
    if cls then
      local members = cls["members"];
      local nodes = {};
      nodes["typename"] = "table";
      nodes["fieldname"] = "ChildNodes";
      nodes["members"] = {};
      if members ~= nil then
        table.insert(members,nodes);
      end
      for k, v in pairs(childList) do
        local childNode = v;
        if childNode._Script then
          --逻辑是除了EDITOR_SCENE/EDITOR_GAME/EDITOR_UI 之外还有其他layer则认为是场景节点，需要序列化出去
          if not childNode:isLayer(apollocore.LayerMask.MC_MASK_EDITOR_SCENE_LAYER)
            and not childNode:isLayer(apollocore.LayerMask.MC_MASK_EDITOR_UI_LAYER) then
          
            local childInfo = self:_SerializeTraverse(childNode);
            local childCls = childInfo[1];
            if childCls then
              childCls["fieldname"] = k; --flatbuffer key can't be empty
              table.insert(nodes["members"],childCls);
            end
          end
        end
      end
    end
  end
  return info;
end

--创建对象
function BundleSystem:_InstantiationCls(typename, host)
  local cls = nil;
  if typename == "table" then --lua table 类型
    cls = {};
  elseif typename == venuscore.ScriptTypes.ReferenceTypeName then--如果是引用类型
    LOG("reference type");
  else --rtti manager创建对象
    if host ~= nil and BundleSystem.DeserializeInitDelegates[host:GetTypeName()] then
      cls = RttiManager:Newinstance(typename,host);
      if cls == nil then
        local func = BundleSystem.DeserializeInitDelegates[host:GetTypeName()];
        cls = func(typename);
      end
    else
      cls = RttiManager:Newinstance(typename,host);
    end
  end
  return cls;
end

--处理对象的属性
function BundleSystem:_Attributes(cls, attributes,nodes, referenceinfo)
  if attributes.__reference_uuid then
    referenceinfo.nodemap[attributes.__reference_uuid] = cls;
    attributes.__reference_uuid = nil;
  end 
  if cls.GetTypeName then
    local typename = cls:GetTypeName();
    if BundleSystem.DeserializeDelegates[typename] then  --自定义了实例化函数
      local func = BundleSystem.DeserializeDelegates[typename];
      func(cls,attributes,nodes);
      --table.insert(nodes,cls);  --实例化出的脚本node加入table中
      return cls;
    end
  end
  for name, attr in pairs(attributes) do
    cls[name] = attr;
  end
  return cls;  --再把cls返回回去
end



--decoder: 解码器
--thisCls: 是否需要创建该类型（如果父类中已经生成了此对象则此值非空)
--nodes: 返回值，创建的脚本node都放入此列表中
--host: 当前对象thisCls的父对象（C++对象）
function BundleSystem:_DeSerializeCls(decoder,thisCls,nodes,host, referenceinfo, parentcls, parentNmae)
  local memberListCnt = decoder:GetLength();
  local cls = thisCls;
  if cls == nil then
    --local typename = decoder:GetFieldName(1);  --序列化时定好的，第一个一定是类型名称
    local typename = decoder:AsString(1);
    if string.find(typename,'Usrscript') ~= nil then
      local usrscriptPath = nil;
      for i = 2, memberListCnt do
        local fieldName = decoder:GetFieldName(i);
        if fieldName == "scriptPath" then
          usrscriptPath = decoder:AsString(i);
        end
      end
      local func,errorstr = loadfile(venuscore.IFileSystem:PathAssembly(usrscriptPath));
      local temp = func();
    end
    cls = self:_InstantiationCls(typename,host);  --创建对象
  end
  local attributes = {};
  for i = 2, memberListCnt do
    local fieldName = decoder:GetFieldName(i);
    local fieldType = decoder:GetFieldType(i);
    local fieldValue = nil;
    if fieldType == FDatatype.DT_BOOL then
      fieldValue = decoder:AsBool(i);
    elseif fieldType == FDatatype.DT_INT then
      fieldValue = decoder:AsInt(i);
    elseif fieldType == FDatatype.DT_FLOAT then
      fieldValue = decoder:AsFloat(i);
    elseif fieldType == FDatatype.DT_DOUBLE then
      fieldValue = decoder:AsDouble(i);
    elseif fieldType == FDatatype.DT_STRING then
      fieldValue = decoder:AsString(i);
    elseif fieldType == FDatatype.DT_REFERENCE then
      local refid = decoder:AsString(i); --ref类型变为闭包，等待序列化完毕刷包
      local callback = {};
      callback.key = refid;
      --callback.fieldName = fieldName;
      callback.func = function(value)
        if type(parentcls) == "table" then
          table.insert(cls, value);
          if #cls == (memberListCnt - 1) then
            host[parentNmae] = cls;
          end
        else
          cls[fieldName] = value;
        end
      end     
      table.insert(referenceinfo.callbacks, callback); 
    elseif fieldType == FDatatype.DT_CLASS then
      local childDecoder = decoder:AsClass(i);
      local childCls = nil;
      if type(cls) == "table" then
        childCls = cls[fieldName];
      else
        childCls = cls[fieldName];
        host = cls;
      end
      fieldValue = self:_DeSerializeCls(childDecoder,childCls,nodes,host, referenceinfo, cls[fieldName], fieldName);  --反序列化子类
    end
    if fieldValue ~=nil then
       attributes[fieldName] = fieldValue;
    end
  end
  return self:_Attributes(cls,attributes,nodes, referenceinfo);  --对于不同对象可能需要对属性做些额外的工作
end


--遍历单个Node构建序列化信息
function BundleSystem:_SerializeTraverseNode(obj,root,rootkey,info)
  local isRef = venuscore.isReference(root, rootkey);
  if isRef then--引用类型，不在进行递归
    local cls = {};
    cls["members"] = {};
    cls["fieldname"] = rootkey;
    if type(obj) == "userdata" then
      cls["typename"] = venuscore.ScriptTypes.ReferenceTypeName;
      cls["value"] = obj:GetObjectID();
    elseif type(obj) == "table" then--table
      cls["typename"] = "table";
      for k, v in pairs(obj) do
        local childCls = {};
        childCls["typename"] = venuscore.ScriptTypes.ReferenceTypeName;
        childCls["value"] = v:GetObjectID();
        childCls["fieldname"] = tostring(k) .. "-" .. rootkey;
        childCls["members"] = {};
        table.insert(cls["members"], childCls);
      end
    end
    table.insert(info,cls);
  else
    local t = type(obj);
    if t == "userdata" then
      local tm = getmetatable(obj);
      local str = obj:GetTypeName();
      local cls = {};
      cls["typename"] = str;
      cls["__reference_uuid"] = obj.GetObjectID and obj:GetObjectID() or nil;
      cls["fieldname"] = rootkey or "";
      cls["members"] = cls["members"] or {};
      table.insert(info,cls);
      for key, handle in MemberIterator(obj) do
        if key ~= "_Script" and key ~= "ChildNodes" then   --避免循环
          self:_SerializeTraverseNode(obj[key],obj,key,cls["members"]);
        end
      end
    elseif t == "table" then  --脚本序列化
      local str = "";
      local cls = {};
      if obj.GetTypeName then  --脚本node对象
        str = obj:GetTypeName();
      else   --普通table
        str = "table";
      end
      cls["typename"] = str;
      cls["__reference_uuid"] = obj.GetObjectID and obj:GetObjectID() or nil;
      cls["fieldname"] = rootkey or "";
      cls["members"] = cls["members"] or {};
      table.insert(info,cls);
      if obj.GetTypeName then  --从venuscore派生的对象是有注册信息的
        for key, handle in MemberIterator(obj) do
          if obj[key] then
            info[key] = self:_SerializeTraverseNode(obj[key], obj, key,cls["members"]);
          end          
        end
      else --普通lua table是没有注册信息的
        for key, handle in pairs(obj) do
          self:_SerializeTraverseNode(obj[key],obj,key,cls["members"]);
        end
      end
    elseif t == "number" or t == "boolean" or t == "string" then
      local cls = {};
      cls["typename"] = t;
      cls["fieldname"] = rootkey;
      cls["members"] = {};
      cls["value"] = obj;
      table.insert(info,cls);
    elseif BundleSystem.SerializeDelegates[rootkey] then
      local func = BundleSystem.SerializeDelegates[rootkey];
      local typename,fieldname = func(obj);
      local cls = {};
      cls["typename"] = typename;
      cls["fieldname"] = rootkey;
      cls["members"] = {};
      cls["value"] = fieldname;
      table.insert(info,cls);
    end
  end
end

return BundleSystem;