local libvenuscore = require "libvenuscore"
local VenusBehavior = require "venuscore.behavior.venusbehavior"


local loaded = {}

return function(path)
  local fullpath = libvenuscore.IFileSystem:PathAssembly(path);
  local callfunction = loaded[fullpath];
  if not callfunction then
    callfunction = dofile(fullpath);
    loaded[fullpath] = callfunction;
  end
  if callfunction then
    local instance = callfunction();
    if instance:is(VenusBehavior) then
      return instance;
    end
  end
  ERROR(string.format("script %s is not type of VenusBehavior", path));
end