local venusjson = require "venusjson"
local venuscore = require "venuscore"

local torch = require "torch"
local AutoTensor = require "torchutility.autotensor"
local Operator = require "torchutility.operator"

local Power = Operator:extend();

function Power:new(tensor, pow)
  Power.super.new(self, tensor);
  self.pow = pow;
  
  if pow == 1 then
    error("useless pow")
  elseif pow == 2 then
    self._Derivative = self._d2;
  else
    self._Derivative = self._dn;
  end
end

function Power:Caculate(param1)
    return torch.pow(param1, self.pow);
end

function Power:_d2(param)
  local d = 2 * self.paramcache[1]:R()
  return torch.diag(d);
end

function Power:_dn(param)
  local n = self.pow;
  d = n * torch.pow(self.paramcache[1]:R(), n - 1);
  return torch.diag(d);
end

function Power:Derivative(param)
  return self:_Derivative(param);
end

function AutoTensor.__pow(no1, no2)
  return Power(no1,no2);
end

return Power;