local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local waterripple = {}
waterripple.Wr = 0;

waterripple.Queue = 107;


function waterripple:Initialize(host, size)  
    --<!--  set the offsets parameters in vertex shader -->
  self.COUNT = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"COUNT"); 
  self.Wr = host:CreateRenderObject("comm:documents/filter/material/waterripple.material" );
  self.Wr:SetParameter(self.COUNT, mathfunction.vector1(0.0));
  return self.Queue;
end

function waterripple:Resizeview(size)
  --self:_SetParam(size);
end

function waterripple:Process(pipeline, Original, Scene, Output)  
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Wr:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.Wr:Draw(pipeline);
end

return waterripple;