local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local sharpen = {}
sharpen.Sp = 0;
sharpen.Queue = 119;


function sharpen:_SetParam(size)  -- fortest
  self.height= size:y();
  self.hOffset=1.0/self.height;
  self.width=size:x();
  self.wOffset=1.0/self.width;
  self.Sp:SetParameter(self.PIXEL_OFFSETS, mathfunction.vector2( self.wOffset, self.hOffset ) );
end

function sharpen:Initialize(host, size)
    --<!--  set the offsets parameters in vertex shader -->
  self.SHARPNESS = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"SHARPNESS");  
  self.PIXEL_OFFSETS = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"PIXEL_OFFSETS");  
  self.SQUARE_COORDINATE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.INTERNAL,"SQUARE_COORDINATE"); 
  self.Sp = host:CreateRenderObject("comm:documents/filter/material/sharpen.material" );
  self.Sp:SetParameter(self.SHARPNESS, mathfunction.vector1( 0.7 ) );
  self:_SetParam(size);
  return self.Queue;
end

function sharpen:Resizeview(size)
  --self:_SetParam(size);
end

function sharpen:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Sp:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.Sp:Draw(pipeline);
end

return sharpen;