local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local rgb2gray = {}
rgb2gray.Rg = 0;
rgb2gray.Queue = 102;



function rgb2gray:Initialize(host, size)
    --<!--  set the offsets parameters in vertex shader -->
  self.COUNT = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"COUNT"); 
  self.Rg = host:CreateRenderObject("comm:documents/filter/material/rgb2gray.material" );
  self.Rg:SetParameter(self.COUNT, mathfunction.vector1(math.pi/12.0));
  --self:_SetParam(size);
  return self.Queue;
end

function rgb2gray:Resizeview(size)
  --self:_SetParam(size);
end

function rgb2gray:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Rg:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.Rg:Draw(pipeline);
end

return rgb2gray;