local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local fourimg = {}
fourimg.Fi = 0;

fourimg.Queue = 200;

function fourimg:Initialize(host, size)
  self.RATIOASPECT = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"RATIOASPECT");
  self.Fi = host:CreateRenderObject("comm:documents/Filter/material/fourimg.material");
  self.Fi:SetParameter(self.RATIOASPECT, mathfunction.vector1(size:y()/size:x()) );
  return self.Queue;
end

function fourimg:Resizeview(size)
end

function fourimg:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Fi:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.Fi:Draw(pipeline);
end

return fourimg;

