local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local colorinvertfilter = {}
colorinvertfilter.Cil = 0;
colorinvertfilter.Queue = 108;



function colorinvertfilter:Initialize(host, size)
    --<!--  set the offsets parameters in vertex shader -->
  self.COUNT = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"COUNT");  
  self.Cil = host:CreateRenderObject("comm:documents/filter/material/colorinvertfilter.material" );
  self.Cil:SetParameter(self.COUNT, mathfunction.vector1(1.0));
  --self:_SetParam(size);
  return self.Queue;
end

function colorinvertfilter:Resizeview(size)
  --self:_SetParam(size);
end

function colorinvertfilter:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Cil:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.Cil:Draw(pipeline);
end

return colorinvertfilter;