local b3 = require 'behavior3.b3';
require 'behavior3.core.Action'

local wait = b3.Class("Wait", b3.Action)
b3.Wait = wait

function wait:ctor(settings)
	b3.Action.ctor(self, settings)

	self.name = "Wait"
	self.title = "Wait <milliseconds>ms"
	self.parameters = {milliseconds = 0,}
  self.endTime = 0;
  if settings.milliseconds ~= nil then
    self.endTime = settings.milliseconds / 1000;
  end
  

	settings = settings or {}
end

function wait:tick(tick)
	local currTime = os.time()
	local startTime = tick.blackboard:get("startTime", tick.tree.id, self.id)

	if not startTime or startTime == 0 then
		startTime = currTime
		tick.blackboard:set("startTime", currTime, tick.tree.id, self.id)
	end

	if currTime - startTime > self.endTime then
		return b3.SUCCESS
	end

	return b3.RUNNING
end
