require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local pixelcut = {}
pixelcut.renderObject = nil;
pixelcut.queue = 313;

function pixelcut:Initialize(host, size)
  
  
  self.X_CUT_SIZE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"X_CUT_SIZE");
  self.Y_CUT_SIZE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"Y_CUT_SIZE");
  self.renderObject = host:CreateRenderObject("comm:documents/material/pixelcut.material" );
  self.renderObject:SetParameter(self.X_CUT_SIZE, mathfunction.vector1(0.99) );
  self.renderObject:SetParameter(self.Y_CUT_SIZE, mathfunction.vector1(1.0) );

  
  return self.queue;

end



function pixelcut:Resizeview(size)
  
end



function pixelcut:Process(pipeline, Original, Scene, Output)
  
    Output:PushRenderTarget();
    Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR);
    self.renderObject:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    self.renderObject:Draw(pipeline);
    
end

return pixelcut;
