local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local mosaic = {}
mosaic.Do = 0;
mosaic.Queue = 310;

function mosaic:Initialize(host, size)
  self.mosaic_size = mathfunction.vector2(1,1);
  self.mosaic_center = mathfunction.vector2(0.5,0.5);

  self.MOSAIC_SIZE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "MOSAIC_SIZE");

  self.TARGETSIZE = apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,
    "TARGETSIZE");

  self.MOSAIC_CENTER = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"MOSAIC_CENTER");


  local pathout = venuscore.IFileSystem:PathAssembly("comm:documents/material/mosaic.material");
  self.Do = host:CreateRenderObject(pathout);

  self.Do:SetParameter(self.TARGETSIZE,size);
  self.Do:SetParameter(self.MOSAIC_SIZE,self.mosaic_size);
  self.Do:SetParameter(self.MOSAIC_CENTER,self.mosaic_center);
  
  host:RegisterScriptParameter(self,"mosaic_size");
  host:RegisterScriptParameter(self,"mosaic_center");
  return self.Queue;
end



function mosaic:Resizeview(size)
  self.Do:SetParameter(self.TARGETSIZE,size);
end

function mosaic:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Do:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  self.Do:SetParameter(self.MOSAIC_CENTER,self.mosaic_center);
  self.Do:SetParameter(self.MOSAIC_SIZE,self.mosaic_size);
	self.Do:Draw(pipeline);
end

return mosaic;