
local ae = require "apolloengine"
local mf = require "mathfunction"

local obj = {}

obj.renderObject = nil
obj.queue = 100
obj.blendFactor = mf.vector1(100)
obj.lastBlendFactor = nil

function obj:Initialize(host, size)

  self.BLEND_FACTOR = ae.IMaterialSystem:NewParameterSlot(
          ae.ShaderEntity.UNIFORM,
          "BLEND_FACTOR")

  self.renderObject = host:CreateRenderObject("comm:documents/material/invert.material")
  self:UpdateParameters()
  host:RegisterScriptParameter(self,"blendFactor");
  
  return self.queue
end

function obj:Resizeview(size)

end

function obj:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget()
  Output:ClearBuffer(ae.RenderTargetEntity.CF_COLOR)

  self.renderObject:SetParameter(
          ae.ShaderEntity.TEXTURE_DIFFUSE,
          Scene:GetAttachment(ae.RenderTargetEntity.TA_COLOR_0));

  self:UpdateParameters()
  self.renderObject:Draw(pipeline)
end

function obj:UpdateParameters()
  if self.blendFactor ~= self.lastBlendFactor then
    self.renderObject:SetParameter(self.BLEND_FACTOR, mf.vector1(self.blendFactor:x() * 0.01))
    self.lastBlendFactor = self.blendFactor
  end
end

return obj;