
local ae = require "apolloengine"
local vc = require "venuscore"
local mf = require "mathfunction"

local obj = {}

obj.renderObject = nil
obj.queue = 100
obj.testingTex = nil

obj.hueAdj = mf.vector1(0)
obj.satAdj = mf.vector1(0)
obj.lumAdj = mf.vector1(0)

obj.lastHueAdj = nil
obj.lastSatAdj = nil
obj.lastLumAdj = nil

function obj:Initialize(host, size)

  self.HSLADJ_HUE = ae.IMaterialSystem:NewParameterSlot(
          ae.ShaderEntity.UNIFORM,
          "HSLADJ_HUE");

  self.HSLADJ_SAT = ae.IMaterialSystem:NewParameterSlot(
          ae.ShaderEntity.UNIFORM,
          "HSLADJ_SAT");

  self.HSLADJ_LUM = ae.IMaterialSystem:NewParameterSlot(
          ae.ShaderEntity.UNIFORM,
          "HSLADJ_LUM");

  self.renderObject = host:CreateRenderObject("comm:documents/material/hsladj.material")

  self:_UpdateParameters()
  
  host:RegisterScriptParameter(self,"hueAdj");
  host:RegisterScriptParameter(self,"satAdj");
  host:RegisterScriptParameter(self,"lumAdj");
  
  --self.testingTex = ae.TextureEntity()
  --self.testingTex:PushMetadata(
  --        ae.TextureFileMetadata(
  --                ae.TextureEntity.TU_STATIC,
  --                ae.TextureEntity.PF_AUTO,
  --                1,
  --                false,
  --                ae.TextureEntity.TW_CLAMP_TO_BORDER,
  --                ae.TextureEntity.TW_CLAMP_TO_BORDER,
  --                ae.TextureEntity.TF_LINEAR,
  --                ae.TextureEntity.TF_LINEAR,
  --                "/sdcard/testing.png"));
  --self.testingTex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS)
  --self.testingTex:CreateResource()

  return self.queue
end

function obj:Resizeview(size)

end

function obj:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget()
  Output:ClearBuffer(ae.RenderTargetEntity.CF_COLOR)

  self.renderObject:SetParameter(
          ae.ShaderEntity.TEXTURE_DIFFUSE,
          Scene:GetAttachment(ae.RenderTargetEntity.TA_COLOR_0));

  --self.renderObject:SetParameter(
  --        ae.ShaderEntity.TEXTURE_DIFFUSE,
  --        self.testingTex);

  --self:UpdateParameters()
  self:_UpdateParameters()
  self.renderObject:Draw(pipeline)
end

function obj:UpdateParameters()
  if self.hueAdj ~= self.lastHueAdj then
    local _, adj = math.modf(self.hueAdj:x() / 360.0)
    self.renderObject:SetParameter(self.HSLADJ_HUE, mf.vector1(adj))
    self.lastHueAdj = self.hueAdj
  end
  if self.satAdj ~= self.lastSatAdj then
    self.renderObject:SetParameter(self.HSLADJ_SAT, mf.vector1(self.satAdj:x() * 0.01))
    self.lastSatAdj = self.satAdj
  end
  if self.lumAdj ~= self.lastLumAdj then
    self.renderObject:SetParameter(self.HSLADJ_LUM, mf.vector1(self.lumAdj:x() * 0.01))
    self.lastLumAdj = self.lumAdj
  end

end

function obj:_UpdateParameters()
    local _, adj = math.modf(self.hueAdj.mx / 360.0)
    self.renderObject:SetParameter(self.HSLADJ_HUE, mf.vector1(adj))
    self.renderObject:SetParameter(self.HSLADJ_SAT, mf.vector1(self.satAdj.mx * 0.01))
    self.renderObject:SetParameter(self.HSLADJ_LUM, mf.vector1(self.lumAdj.mx * 0.01))
end

return obj;