require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local blendlayer = {}

blendlayer.renderObject = nil;
blendlayer.queue = 100;

function blendlayer:Initialize(host, size)
  self.renderObject = host:CreateRenderObject("comm:documents/shaders/posteffect/blendmode.material");
  
  self.BlendTex = apolloengine.TextureEntity();
  self.BlendOpacity = mathfunction.vector1(1.0);
  self.BlendMode = mathfunction.vector1(1.0);
  
  host:RegisterScriptParameter(self, "BlendTex");
  host:RegisterScriptParameter(self, "BlendOpacity");
  host:RegisterScriptParameter(self, "BlendMode");

  return self.queue;
end

function blendlayer:Resizeview(size)
--firstmaterialentity:SetParameter("_MainTex", tex);
end

function blendlayer:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
  
  local materials = self.renderObject.MaterialEntities;
  local material = materials[1];
  material:SetParameter("_MainTex", Scene:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0));
  material:SetParameter("_BlendTex", self.BlendTex);
  material:SetParameter("_BlendOpacity", self.BlendOpacity);
  material:SetParameter("_BlendMode", self.BlendMode);

  
  self.renderObject:Draw(pipeline);
end

return blendlayer;