require "utility"
local ae = require "apolloengine"
local vc = require "venuscore"
local mf = require "mathfunction"
local vj = require "venusjson"

local obj = {}

local BLEND_NORMAL = "normal"
local BLEND_SCREEN = "screen"


function obj:Initialize(host, size)

    self.host = host
    self.order = 100

    self.TEXTURE_CLIPART = ae.IMaterialSystem:NewParameterSlot(
            ae.ShaderEntity.UNIFORM,
            "TEXTURE_CLIPART");

    self.blendMaterials = {}

    self.blendMaterials[BLEND_NORMAL] = "comm:documents/material/clipart_blend_alpha.material"
    self.blendMaterials[BLEND_SCREEN] = "comm:documents/material/clipart_blend_screen.material"

    self.identityRenderer = host:CreateRenderObject("comm:documents/material/identity.material")
    self.blendRenderer = nil

    self:_InitializeParameters()

    self:_UpdateParameters()

    return self.order
end

function obj:Resizeview(size)
end

function obj:Process(pipeline, Original, Scene, Output)

    self:_UpdateParameters()

    local colorClear = ae.RenderTargetEntity.CF_COLOR
    local color0 = ae.RenderTargetEntity.TA_COLOR_0

    self.blendRenderer:SetParameter(
            ae.ShaderEntity.TEXTURE_DIFFUSE,
            Original:GetAttachment(color0))

    self.blendRenderer:SetParameter(
            self.TEXTURE_CLIPART,
            Scene:GetAttachment(color0))

    Output:PushRenderTarget()
    Output:ClearBuffer(colorClear)
    self.blendRenderer:Draw(pipeline)

    if self.writeBack then
        self.identityRenderer:SetParameter(
                ae.ShaderEntity.TEXTURE_DIFFUSE,
                Output:GetAttachment(color0))
        Original:PushRenderTarget()
        Original:ClearBuffer(colorClear)
        self.identityRenderer:Draw(pipeline)
    end
end

local function _CreateDefaultConfig()
    local json = {
        writeBack = false,
        blend = "overlay"
    }
    return vj.StoreJsonString(json)
end

function obj:_InitializeParameters()

    self.blenderConfig = _CreateDefaultConfig()
    self.lastBlenderConfig = nil
    self.writeBack = false

end

function obj:_UpdateParameters()

    if self.lastBlenderConfig ~= self.blenderConfig then

        local config = vj.LoadJsonString(self.blenderConfig)

        local material = self.blendMaterials[config.blend]

        if material ~= nil then
            self.blendRenderer = self.host:CreateRenderObject(material)
        else
            self.blendRenderer = self.host:CreateRenderObject(self.blendMaterials[BLEND_NORMAL])
        end

        self.writeBack = config.writeBack

        self.lastBlenderConfig = self.blenderConfig
    end
end

return obj