require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local adjustlevel = {}

adjustlevel.renderObject = nil;
adjustlevel.queue = 100;

function adjustlevel:Initialize(host, size)
  
  self.input = mathfunction.vector2(0.0,255.0);
  self.output = mathfunction.vector2(0.0,255.0);
  self.gamma = 1.0
  
  self._MainTex = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"_MainTex");
  self._Output = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"_Output");
  self._Input = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"_Input");

  self.renderObject = host:CreateRenderObject("comm:documents/shaders/posteffect/leveladjust.material");
  
  self:UpdateParameters();
 
  host:RegisterScriptParameter(self,"input");
  host:RegisterScriptParameter(self,"gamma");
  host:RegisterScriptParameter(self,"output");
  return self.queue;
end

function adjustlevel:Resizeview(size)

end

function adjustlevel:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
  self.renderObject:SetParameter(
          self._MainTex,
          Scene:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0));
        
  self:UpdateParameters();
  self.renderObject:Draw(pipeline);
end

function adjustlevel:UpdateParameters()
    local inshadow = self.input:x();
    local inhighlight = self.input:y();

    local outshadow = self.output:x();
    local outhighlight = self.output:y();
    
    self.renderObject:SetParameter(self._Output, mathfunction.vector2(outshadow,outhighlight));
    self.renderObject:SetParameter(self._Input, mathfunction.vector3(inshadow,self.gamma,inhighlight));
end

return adjustlevel;