local apollocore = require "apollocore"
local venuscore = require "venuscore"
local spinefunction = require "spinefunction"

local SpineNode =  venuscore.ActorNode:extend("SpineAnimationNode");

venuscore.BundleSystem:OnDeserialize(SpineNode:GetTypeName(),
        function(cls,attributes,nodes)
          if cls then
            for name,attr in pairs(attributes) do
              if string.find(name,'childnode') then
                cls:AttachNode(attr);
              end
            end
            table.insert(nodes,cls);
          end
          cls:SetLastSkin();
          cls:PushLastAnimation();
        end)
venuscore.BundleSystem:OnDeserialize(spinefunction.SpineNode:GetTypeName(),
        function(cls,attributes)
          for name, attr in pairs(attributes) do
            if name == "Layer" then
              local layer = venuscore.Utility:ConvertStringToUInt64(attr);
              cls[name] = layer;
            elseif name == "Components" then

            else
              cls[name] = attr;
            end
          end
          cls:CreateResource();
        end)

SpineNode:MemberRegister("node");

function SpineNode:new()
  self.ScriptComponents = {}; --用来保存脚本component对象
  self.node = spinefunction.SpineNode();
  self.node._Script = self;
  self.node:SetName("SpineNode");
  self.RenerComponent = self.node:GetRenderComponent();
  self.SpineComponent = self.node:GetSpineComponent();
  self.TransformComponent = self.node:CreateComponent(apollocore.Node.CT_TRANSFORM);
end

function SpineNode:GetNativeNode()
  return self.node;
end

function SpineNode:GetName()
  return self.node:GetName();
end

function SpineNode:SetName(name)
  self.node:SetName(name);
end

function SpineNode:SetLocalPosition(pos)
  self.TransformComponent:SetLocalPosition(pos);
end

function SpineNode:SetLocalRotation(rot)
  self.TransformComponent:SetLocalRotation(rot);
end

function SpineNode:SetLocalScale(scale)
  self.TransformComponent:SetLocalScale(scale);
end

function SpineNode:CreateResource(atlas, skel, material)
  self.SpineComponent:PushMetadata(
          apollocore.PathMetadata(atlas));
  self.SpineComponent:PushMetadata(
          apollocore.PathMetadata(skel));
  self.RenerComponent:PushMetadata(
          apollocore.RenderObjectMaterialMetadata(
                  apollocore.PathMetadata(material)));

  return self.node:CreateResource();
end

function SpineNode:PushAnimation(name, loop, delay)
  self.SpineComponent:PushAnimation(name, loop, delay);
end

function SpineNode:PushLastAnimation()
  self.SpineComponent:PushAnimation(self.SpineComponent.AnimationName,
          self.SpineComponent.AnimationLoop, self.SpineComponent.AnimationDelay);
end

function SpineNode:SetLastSkin()
  self.SpineComponent:SetSkin(self.SpineComponent.SkinName);
end

function SpineNode:GetDefaultAnimation()
  return self.SpineComponent:GetAllAnimationNames()[1];
end

function SpineNode:ClearAnimation()
  self.SpineComponent:ClearAnimation();
end

function SpineNode:UpdateAnimation(diff)
  return self.node:UpdateAnimation(diff);
end

function SpineNode:Update(diff)
  self:UpdateAnimation(diff);
end

function SpineNode:SetSkin(name)
  return self.SpineComponent:SetSkin(name);
end

function SpineNode:FindBone(name)
  return self.SpineComponent:FindBone(name);
end

function SpineNode:SetShow(isshow)
  if self.isshow ~= isshow then
    self.isshow = isshow;
    if isshow then
      self.RenerComponent:SetRenderProperty(apollocore.RenderComponent.RP_SHOW);
    else
      self.RenerComponent:EraseRenderProperty(apollocore.RenderComponent.RP_SHOW);
    end
  end
end

function SpineNode:BindPose()
  self.node:BindPose();
end

function SpineNode:SetLayer(layer)
  self.node:SetLayer(layer);
end

function SpineNode:OnSerializeStarted()
end

function SpineNode:OnSerializeFinished()
end

function SpineNode:OnDeserializeFinished()
end

return SpineNode;
