local mathfunction = require "mathfunction"
local apollocore = require "apollocore"
local venuscore = require "venuscore"

local VenusBehavior = require "venuscore.behavior.venusbehavior"

local JointNode =  venuscore.ActorNode:extend("JointNode");


venuscore.BundleSystem:OnDeserialize(JointNode:GetTypeName(),
        function(cls,attributes,nodes)
          for name,attr in pairs(attributes) do
            if string.find(name,'ChildNodes') then
              for k, v in pairs(attr) do
                cls:AttachNode(v);
              end 
            end
          end
          table.insert(nodes,cls);
        end)


JointNode:MemberRegister("node");


function JointNode:new() 
  self.node = apollocore.Node();  
  self.node._Script = self;
  self.skeletonJoint = self:CreateComponent(apollocore.Node.CT_TRANSFORM_MARTIX); 
end


function JointNode:CreateComponent(ct)
  local component = nil;
  if self.node then
    component = self.node:CreateComponent(ct);
  end
  return component;
end

function JointNode:GetComponent(ct)
  local component = nil;
  if self.node then
    component = self.node:GetComponent(ct);
  end
  return component;
end


function JointNode:OnSerializeStarted()
  
  local components = self.node.Components;
  for comType, comp in pairs(components) do
    local typename = comp:GetTypeName();
    if venuscore.BundleSystem.SerializeStartedDelegates[typename] then  
      local func = venuscore.BundleSystem.SerializeStartedDelegates[typename];
      func(comp,nil);
    end
  end
end

function JointNode:OnSerializeFinished()
  local components = self.node.Components;
  for comType, comp in pairs(components) do
    local typename = comp:GetTypeName();
      if venuscore.BundleSystem.SerializeFinishedDelegates[typename] then  
        local func = venuscore.BundleSystem.SerializeFinishedDelegates[typename];
        func(comp,nil);
    end
  end
end


function JointNode:OnDeserializeFinished()
  --循环所有的component,调用其回调
  local components = self.node.Components;
  for comType, comp in pairs(components) do
    local typename = comp:GetTypeName();
    if venuscore.BundleSystem.DeserializeFinishedDelegates[typename] then  
      local func = venuscore.BundleSystem.DeserializeFinishedDelegates[typename];
      func(comp,nil);
    end
  end
end

function JointNode:GetNativeNode()
  return self.node;
end


return JointNode;