local mathfunction = require "mathfunction"
local apollocore = require "apollocore"
local venuscore = require "venuscore"

local VenusBehavior = require "venuscore.behavior.venusbehavior"

local GenericNode =  venuscore.ActorNode:extend("GenericNode");

venuscore.BundleSystem:OnSerialize("Layer",
        function(obj)
          return "string",tostring(tonumber(obj));
        end
)

venuscore.BundleSystem:OnSerialize("LayerMask",
        function(obj)
          return "string",tostring(tonumber(obj));
        end
)

venuscore.BundleSystem:OnDeserialize(GenericNode:GetTypeName(),
        function(cls,attributes,nodes)
          for name,attr in pairs(attributes) do
            if string.find(name,'ChildNodes') then
              for k, v in pairs(attr) do
                cls:AttachNode(v);
              end 
            end
          end
          table.insert(nodes,cls);
        end)

--Node的layer需要调用转换为number
venuscore.BundleSystem:OnDeserialize(apollocore.Node:GetTypeName(),
        function(cls,attributes)
          for name, attr in pairs(attributes) do
              if name == "Layer" then
                local layer = venuscore.Utility:ConvertStringToUInt64(attr);
                cls[name] = layer;
              else
                cls[name] = attr;
              end
          end
        end
)

--CameraComponent的layer需要调用转换为number
venuscore.BundleSystem:OnDeserialize(apollocore.CameraComponent:GetTypeName(),
        function(cls,attributes) --cls is cameracomponent
          for name, attr in pairs(attributes) do
              if name == "LayerMask" then
                local layer = venuscore.Utility:ConvertStringToUInt64(attr);
                cls[name] = layer;
              else
                cls[name] = attr;
              end
          end

          for name,attr in pairs(attributes) do 
            if name == "PosteffctList" then
              local posteffectlist = attr;
              for key,value in pairs(posteffectlist) do
                local post = value["PostEffectEntity"];
                if value["Status"] == true then
                  cls:AttachPostEffect(post);
                end
              end
            end
          end
          
        end
)
      
--RenderComponent需要调用CeateResource
venuscore.BundleSystem:OnDeserialize(apollocore.RenderComponent:GetTypeName(),
  function(cls,attributes)
    for name, attr in pairs(attributes) do
        if name == "BindBox" then
          cls["OriginalBindBox"] = attr;
        elseif name == "MaterialEntities" and cls:GetHostNode():GetTypeName() == "SpineNode" then
          local spinematerial = nil;
          if attr ~= nil and attr[1] ~= nil and attr[1].SourceMetadata ~= nil then
            spinematerial = attr[1].SourceMetadata[1] or "comm:documents/shaders/legacy/spine/spine_3d.material";
          end
          cls:PushMetadata(apollocore.RenderObjectMaterialMetadata(spinematerial));
        else
          cls[name] = attr;
        end
    end
    if cls:GetHostNode():GetTypeName() == "SpineNode" then
      return;
    end
    cls:CreateResource();
  end
)

--venuscore.BundleSystem:OnDeserialize(apollocore.MaterialEntity:GetTypeName(),
--  function(cls,attributes)
--    local attrPara;
--    for _, attr in pairs(attributes) do
--      if attr then
--        if attr[1] == "ParameterList" then
--          attrPara = attr;
--        else
--          cls[attr[1]] = attr[2];
--        end
--      end
--    end
--    cls:CreateResource();
--    if attrPara~= nil then
--      cls[attrPara[1]] = attrPara[2];
--    end
--  end
--)

--PosteffectEntity需要调用CeateResource
venuscore.BundleSystem:OnDeserialize(apollocore.PostEffectEntity:GetTypeName(),
  function(cls,attributes)
    local parameterlist = nil;
    local queue = nil;
    for name, attr in pairs(attributes) do
      if name == "ScriptPath" then
        local MeshData = attr;
        local path = MeshData[1].Path;
        cls:PushMetadata(apollocore.PathMetadata(path));
        cls:CreateResource();
      elseif name == "Queue" then
        queue = attr;
      else
        parameterlist = attr;
      end
    end
    cls.Parameters = parameterlist; 
    cls.Queue = queue;
  end
)

--RenderTargetEntity需要调用CeateResource
venuscore.BundleSystem:OnDeserialize(apollocore.RenderTargetEntity:GetTypeName(),
  function(cls,attributes)
    for name, attr in pairs(attributes) do
      if attr then
        cls[name] = attr;
      end
    end
    cls:CreateResource();
  end
)

--ScriptComponent反序列化特殊处理
venuscore.BundleSystem:OnDeserialize(apollocore.ScriptComponent:GetTypeName(),
  function(cls,attributes)
    for name, attr in pairs(attributes) do
        if name == "Instances" then
          local instances = attr;
          for path,data in pairs(instances) do
            local instance = venuscore.LoadBehavior(path);
            for k,v in pairs(data) do
              instance[k] = v;
            end
            cls:InsertInstance(instance, path);
          end
        end
    end
  end
)

venuscore.BundleSystem:OnDeserializeInit(apollocore.ScriptComponent:GetTypeName(),
  function(typename)
    local instance = {};
    return instance;
  end
)

-- MorpherComponent需要调用CeateResource
venuscore.BundleSystem:OnDeserialize(apollocore.MorpherComponent:GetTypeName(),
      function(cls,attributes)
        for name, attr in pairs(attributes) do
          if attr then
            cls[name] = attr;
          end
        end
        cls:CreateResource();
      end
)

venuscore.BundleSystem:OnDeserialize(apollocore.AnimationComponent:GetTypeName(),
  function(cls,attributes)
    for name, attr in pairs(attributes) do
          cls[name] =attr;
    end
  end
)

venuscore.BundleSystem:OnSerializeStarted(apollocore.AnimationComponent:GetTypeName(),
  function(component,data)
    component:OnSerializeStarted();
  end
)

venuscore.BundleSystem:OnSerializeFinished(apollocore.AnimationComponent:GetTypeName(),
  function(component,data)
    component:OnSerializeFinished();
  end
)

venuscore.BundleSystem:OnDeserializeFinished(apollocore.ScriptComponent:GetTypeName(),
  function(component,data)
    local instances = component.Instances;
    for key,value in pairs(instances) do
      value:Awake();
    end
  end
)

venuscore.BundleSystem:OnDeserializeFinished(apollocore.AnimationComponent:GetTypeName(),
  function(component,data)
    component:CreateResource();
    component:OnDeserializeFinished();
  end
)

venuscore.BundleSystem:OnDeserializeFinished(apollocore.MorpherComponent:GetTypeName(),
        function(component,data)
          component:OnDeserializeFinished();
        end
)

venuscore.BundleSystem:OnDeserialize(apollocore.SkeletonComponent:GetTypeName(),
  function(cls,attributes)
    for name, attr in pairs(attributes) do
      if attr then
          cls[name] = attr;
      end
    end
  end
)

venuscore.BundleSystem:OnDeserializeFinished(apollocore.SkinComponent:GetTypeName(),
        function(component,data)
          component:OnDeserializeFinished();
        end
)

--TextureEntity需要调用CeateResource
venuscore.BundleSystem:OnDeserialize(apollocore.TextureEntity:GetTypeName(),
  function(obj, attributes)
    for name, attr in pairs(attributes) do
      if attr then
        obj[name] = attr;
      end
    end
    obj:CreateResource();
  end
)

GenericNode:MemberRegister("node");
GenericNode:MemberRegister("_version");


--isDeserialize: 标识是否是通过反序列化创建对象
function GenericNode:new() 
  --GenericNode.super.new(self);
  self.node = apollocore.Node();  --从C++开始序列化，这里的node就不需要序列化了
  self.node._Script = self;
  self._trans = self:CreateComponent(apollocore.Node.CT_TRANSFORM); --默认会有一个transform component
  self._trans:SetLocalPosition(mathfunction.vector3(0.0,0.0,0.0));
  self._version = 1;
end

function GenericNode:SetLocalRotation(q)
  self._trans:SetLocalRotation(q);
end

function GenericNode:CreateComponent(ct)
  local component = nil;
  if self.node then
    component = self.node:CreateComponent(ct);
  end
  return component;
end

function GenericNode:GetComponent(ct)
  local component = nil;
  if self.node then
    component = self.node:GetComponent(ct);
  end
  return component;
end


function GenericNode:Update(def)
  local components = self.node.Components;
  for comType, com in pairs(components) do
    local tm = getmetatable(com);
    if tm.Update then
      com:Update(def);
    end
    
    --测试ScriptComponent的Update
    local tm = getmetatable(com);
    if tm.Instances then
      for scrKey,scrValue in pairs(com.Instances) do
        if scrValue then
          scrValue:Update(def);
        end
      end
    end
  end

end


function GenericNode:SetLayer(layer)
  self.node:SetLayer(layer);
end

function GenericNode:OnSerializeStarted()
  --循环所有的component,调用其回调
  
  local components = self.node.Components;
  for comType, comp in pairs(components) do
    local typename = comp:GetTypeName();
    if venuscore.BundleSystem.SerializeStartedDelegates[typename] then  
      local func = venuscore.BundleSystem.SerializeStartedDelegates[typename];
      func(comp,nil);
    end
  end
end

function GenericNode:OnSerializeFinished()
  --循环所有的component,调用其回调
  local components = self.node.Components;
  for comType, comp in pairs(components) do
    local typename = comp:GetTypeName();
      if venuscore.BundleSystem.SerializeFinishedDelegates[typename] then  
        local func = venuscore.BundleSystem.SerializeFinishedDelegates[typename];
        func(comp,nil);
    end
  end
end


function GenericNode:OnDeserializeFinished()
  --循环所有的component,调用其回调
  local components = self.node.Components;
  for comType, comp in pairs(components) do
    local typename = comp:GetTypeName();
    if venuscore.BundleSystem.DeserializeFinishedDelegates[typename] then  
      local func = venuscore.BundleSystem.DeserializeFinishedDelegates[typename];
      func(comp,nil);
    end
  end
end

function GenericNode:GetNativeNode()
  return self.node;
end

function GenericNode:InitializeNodeWithDefaultMaterial(mesh, isMeshKeepSource, bindbox, material)
  local mu = apollocore.VertexBufferEntity.MU_STATIC;
  if isMeshKeepSource then
    mu = apollocore.VertexBufferEntity.MU_DYNAMIC;
  end
  local RenderComponent = self:CreateComponent(apollocore.Node.CT_RENDER);
  RenderComponent:PushMetadata(apollocore.RenderObjectMeshFileMetadate(mu, mesh));

  RenderComponent:PushMetadata(
          apollocore.RenderObjectMaterialMetadata(
                  apollocore.PathMetadata(material)));
  RenderComponent:CreateResource();
  RenderComponent:SetBindBox(bindbox);
  self.TEXTURE_DIFFUSE = apollocore.IMaterialSystem:NewParameterSlot(apollocore.ShaderEntity.UNIFORM,"TEXTURE_DIFFUSE");
  self.TEXTURE_SHADOW_DEPTH = apollocore.IMaterialSystem:NewParameterSlot(apollocore.ShaderEntity.UNIFORM,"TEXTURE_SHADOW_DEPTH");
  self.blankimage = apollocore.TextureEntity();
  self.blankimage:PushMetadata(apollocore.TextureFileMetadata(
          apollocore.TextureEntity.TU_STATIC,
          apollocore.TextureEntity.PF_AUTO,1,true,
          apollocore.TextureEntity.TW_CLAMP_TO_EDGE,
          apollocore.TextureEntity.TW_CLAMP_TO_EDGE,
          apollocore.TextureEntity.TF_LINEAR,
          apollocore.TextureEntity.TF_LINEAR_MIPMAP_LINEAR,
          "comm:documents/texture/material/blank.jpg"));
  self.blankimage:CreateResource();
  RenderComponent:SetParameter(self.TEXTURE_DIFFUSE,self.blankimage);
  RenderComponent:SetParameter(self.TEXTURE_SHADOW_DEPTH,self.blankimage);
end

return GenericNode;